/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.rmonitor.looper;

import android.os.Looper;
import com.tencent.bugly.proguard.cj;
import com.tencent.bugly.proguard.ha;
import com.tencent.bugly.proguard.hs;
import com.tencent.bugly.proguard.hz;
import com.tencent.bugly.proguard.it;
import com.tencent.bugly.proguard.ms;
import com.tencent.bugly.proguard.mt;
import com.tencent.bugly.proguard.mv;
import com.tencent.bugly.proguard.mw;
import com.tencent.rmonitor.base.config.ConfigProxy;
import com.tencent.rmonitor.common.logger.Logger;
import com.tencent.rmonitor.looper.LooperConfig;
import com.tencent.rmonitor.looper.LooperObserver;
import com.tencent.rmonitor.looper.provider.LooperStackProvider;
import com.tencent.rmonitor.looper.provider.StackQueueProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0002J\b\u0010\b\u001a\u00020\tH\u0002J\b\u0010\n\u001a\u00020\u000bH\u0002J\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u000e\u001a\u00020\u0004H\u0016J\b\u0010\u000f\u001a\u00020\u0004H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0011H\u0016J\b\u0010\u0014\u001a\u00020\u0011H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/tencent/rmonitor/looper/LooperMonitor;", "Lcom/tencent/rmonitor/base/plugin/monitor/RMonitorPlugin;", "()V", "isStart", "", "lagObserver", "Lcom/tencent/rmonitor/looper/LagObserver;", "createLagObserver", "createLagParam", "Lcom/tencent/rmonitor/looper/provider/LagParam;", "createLooperStackProvider", "Lcom/tencent/rmonitor/looper/provider/LooperStackProvider;", "getPluginName", "", "isResume", "isRunning", "pause", "", "resume", "start", "stop", "Companion", "bugly-pro_release"})
public final class LooperMonitor
extends it {
    private ms lagObserver;
    private boolean isStart;
    private static final String TAG = "RMonitor_lag";
    public static final Companion Companion = new Companion(0);

    @Override
    public final void start() {
        if (!LooperConfig.INSTANCE.isCanCollect("looper_stack")) {
            Logger.INSTANCE.i(TAG, "start Lag Monitor fail for can't collect.");
            this.isStart = false;
            this.notifyStartResult(1, "can not collect");
            return;
        }
        if (this.isStart) {
            return;
        }
        LooperMonitor looperMonitor = this;
        synchronized (looperMonitor) {
            if (!this.isStart) {
                ms ms2 = this.createLagObserver();
                if (ms2 != null) {
                    ms2.start();
                    this.lagObserver = ms2;
                    this.isStart = true;
                }
                cj.aP().A("looper_stack");
            }
        }
        if (this.isStart) {
            this.notifyStartResult(0, null);
        } else {
            this.notifyStartResult(2, "Lag Observer is null");
        }
        this.resume();
        Logger.INSTANCE.i(TAG, "start Lag Monitors.");
    }

    @Override
    public final boolean isResume() {
        ms ms2 = this.lagObserver;
        if (ms2 != null) {
            return ms2.isResume();
        }
        return false;
    }

    @Override
    public final void pause() {
        if (this.isStart) {
            ms ms2 = this.lagObserver;
            if (ms2 != null) {
                ms2.pause();
                return;
            }
        }
    }

    @Override
    public final void resume() {
        if (this.isStart) {
            ms ms2 = this.lagObserver;
            if (ms2 != null) {
                ms2.resume();
                return;
            }
        }
    }

    @Override
    public final void stop() {
        if (!this.isStart) {
            return;
        }
        this.pause();
        LooperMonitor looperMonitor = this;
        synchronized (looperMonitor) {
            if (this.isStart) {
                ms ms2 = this.lagObserver;
                if (ms2 != null) {
                    ms2.stop();
                }
                this.lagObserver = null;
                this.isStart = false;
            }
        }
        this.notifyStopResult(0, null);
        Logger.INSTANCE.i(TAG, "stop Lag Monitor.");
    }

    @Override
    @Nullable
    public final String getPluginName() {
        return "looper_stack";
    }

    @Override
    public final boolean isRunning() {
        return this.isStart;
    }

    private final ms createLagObserver() {
        ms ms2;
        Object object = this.createLagParam();
        if (Intrinsics.areEqual((Object)((mv)object).xj, (Object)"vsync")) {
            ms2 = new mt((mv)object);
        } else {
            Looper looper = Looper.getMainLooper();
            Intrinsics.checkExpressionValueIsNotNull((Object)looper, (String)"Looper.getMainLooper()");
            ms2 = new LooperObserver(looper, (mv)object);
        }
        object = ms2;
        ms2.setStackProvider(this.createLooperStackProvider());
        return object;
    }

    private final mv createLagParam() {
        hs hs2;
        mv mv2 = new mv();
        hz hz2 = LooperConfig.INSTANCE.getPluginConfig("looper_stack");
        if (!(hz2 instanceof hs)) {
            hz2 = null;
        }
        if ((hs2 = (hs)hz2) != null) {
            mv2.xE = hs2.xE;
            mv2.threshold = hs2.xG;
            mv2.CO = hs2.fv();
            mv2.CP = hs2.fA();
            mv2.xj = hs2.xj;
        } else {
            mv2.xE = 0.1f;
            mv2.threshold = 200L;
            mv2.CO = 52L;
            mv2.CP = true;
            mv2.xj = "msg";
        }
        Logger.INSTANCE.d(TAG, "createLagParam lagParam: ".concat(String.valueOf(mv2)));
        return mv2;
    }

    private final LooperStackProvider createLooperStackProvider() {
        LooperStackProvider looperStackProvider = null;
        ConfigProxy.INSTANCE.getConfig();
        Object object = ha.getPluginConfig("looper_stack");
        if (object instanceof hs && Math.random() < (double)((hs)object).fu()) {
            object = new mw();
            if (mw.hA()) {
                looperStackProvider = (LooperStackProvider)object;
            }
        }
        if (looperStackProvider == null) {
            looperStackProvider = new StackQueueProvider();
        }
        Logger.INSTANCE.d(TAG, "createLooperStackProvider, stackProvider: ".concat(String.valueOf(looperStackProvider)));
        return looperStackProvider;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/tencent/rmonitor/looper/LooperMonitor$Companion;", "", "()V", "TAG", "", "bugly-pro_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(byte by2) {
            this();
        }
    }
}

