/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bugly.traffic.custom;

import com.tencent.bugly.common.network.NetworkWatcher;
import com.tencent.bugly.proguard.gj;
import com.tencent.rmonitor.common.logger.Logger;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;

public class SocketInfo {
    public String type;
    public boolean ssl;
    public boolean isProxy = false;
    public boolean isDnsCache = false;
    public String url = "";
    public String protocol;
    public String host;
    public String ip = "";
    public int port;
    public String version;
    public String method = "";
    public String path;
    public String fd;
    public int implHashCode;
    public long threadId;
    public int networkType;
    public int frontState;
    public String contentType = "";
    public long startTimeStamp;
    public long endTimeStamp;
    public long sslTime;
    public long dnsTime;
    public long tcpTime;
    public long duringTime;
    public long firstPacketPeriod;
    public long totalConnectPeriod;
    public long lastWriteStamp;
    public long sendBytes;
    public long receivedBytes;
    public boolean gzip;
    public boolean chunked;
    public long contentLength;
    public int errorCode = 0;
    public int statusCode = 0;
    public String apnType = NetworkWatcher.INSTANCE.getNetworkState(true).getValue();
    public String pageId = "";
    public Exception exception = null;
    public boolean isEnd;
    public boolean hasSaved = false;
    public long reqStart;
    public long reqEnd;
    public long respStart;
    public long respEnd;
    public long sslConnStart;
    public long sslConnEnd;
    public long redirectStart;
    public long redirectEnd;
    public long connStart;
    public long connEnd;
    public long dnsStart;
    public long dnsEnd;
    public Map<String, String> requestHeaders = new HashMap<String, String>();
    public Map<String, String> responseHeaders = new HashMap<String, String>();

    public static int getErrorCode(Exception exception) {
        if (exception instanceof IOException) {
            gj.ey();
            if (gj.a(exception)) {
                return 911;
            }
            String string = exception.getMessage();
            if (string != null && string.contains("ftruncate failed: ENOENT (No such file or directory)")) {
                return 917;
            }
        }
        if (exception instanceof UnknownHostException) {
            return 901;
        }
        return 903;
    }

    public void resetForOutput() {
        this.gzip = false;
        this.chunked = false;
        this.contentLength = 0L;
    }

    public void resetForInput() {
        this.gzip = false;
        this.chunked = false;
        this.contentLength = 0L;
    }

    public void writeStamp(long l2) {
        this.lastWriteStamp = l2;
        this.isEnd = false;
    }

    public void readStamp(long l2) {
        if (l2 <= this.lastWriteStamp) {
            Logger.INSTANCE.d("SocketInfo", "get first package", ", firstReadTime:", String.valueOf(l2), ", lastWriteStamp:", String.valueOf(this.lastWriteStamp), ", hostName:", this.host);
            return;
        }
        if (l2 - this.lastWriteStamp >= 20000L) {
            Logger.INSTANCE.d("SocketInfo", "first package is too big", ", firstReadTime:", String.valueOf(l2), ", lastWriteStamp:", String.valueOf(this.lastWriteStamp), ", hostName:", this.host);
            return;
        }
        if (!this.isEnd) {
            this.isEnd = true;
            this.firstPacketPeriod = (int)(l2 - this.lastWriteStamp);
        }
        this.totalConnectPeriod = l2 - this.lastWriteStamp;
    }

    public SocketInfo cloneSocketInfo() {
        SocketInfo socketInfo = new SocketInfo();
        new SocketInfo().ssl = this.ssl;
        socketInfo.url = this.url;
        socketInfo.protocol = this.protocol;
        socketInfo.host = this.host;
        socketInfo.ip = this.ip;
        socketInfo.port = this.port;
        socketInfo.version = this.version;
        socketInfo.method = this.method;
        socketInfo.path = this.path;
        socketInfo.fd = this.fd;
        socketInfo.implHashCode = this.implHashCode;
        socketInfo.threadId = this.threadId;
        socketInfo.networkType = this.networkType;
        socketInfo.frontState = this.frontState;
        socketInfo.contentType = this.contentType;
        socketInfo.startTimeStamp = this.startTimeStamp;
        socketInfo.firstPacketPeriod = this.firstPacketPeriod;
        socketInfo.totalConnectPeriod = this.totalConnectPeriod;
        socketInfo.lastWriteStamp = this.lastWriteStamp;
        socketInfo.gzip = this.gzip;
        socketInfo.chunked = this.chunked;
        socketInfo.contentLength = this.contentLength;
        socketInfo.errorCode = this.errorCode;
        socketInfo.statusCode = this.statusCode;
        socketInfo.apnType = this.apnType;
        socketInfo.pageId = this.pageId;
        socketInfo.exception = this.exception;
        socketInfo.isEnd = this.isEnd;
        socketInfo.hasSaved = this.hasSaved;
        socketInfo.reqStart = this.reqStart;
        socketInfo.reqEnd = this.reqEnd;
        socketInfo.respStart = this.respStart;
        socketInfo.respEnd = this.respEnd;
        socketInfo.sslConnStart = this.sslConnStart;
        socketInfo.sslConnEnd = this.sslConnEnd;
        socketInfo.redirectStart = this.redirectStart;
        socketInfo.redirectEnd = this.redirectEnd;
        socketInfo.connStart = this.connStart;
        socketInfo.connEnd = this.connEnd;
        socketInfo.dnsStart = this.dnsStart;
        socketInfo.dnsEnd = this.dnsEnd;
        return socketInfo;
    }
}

