/*
 * Decompiled with CFR 0.152.
 */
package com.telenor.connect.ui;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.webkit.WebView;
import android.widget.Button;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.telenor.connect.ConnectCallback;
import com.telenor.connect.R;
import com.telenor.connect.headerenrichment.HeFlowDecider;
import com.telenor.connect.id.ParseTokenCallback;
import com.telenor.connect.ui.ConnectWebViewClient;
import com.telenor.connect.ui.WebErrorView;
import com.telenor.connect.utils.ConnectUrlHelper;
import com.telenor.connect.utils.WebViewHelper;

public class ConnectWebFragment
extends Fragment {
    private ConnectCallback callback;
    private ConnectWebViewClient client;
    private WebView webView;

    public void onAttach(Context context) {
        super.onAttach(context);
        try {
            this.callback = (ConnectCallback)context;
        }
        catch (ClassCastException e) {
            throw new ClassCastException(context.toString() + " must implement ConnectCallback");
        }
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.com_telenor_connect_web_fragment, container, false);
        this.webView = (WebView)view.findViewById(R.id.com_telenor_connect_fragment_webview);
        ViewStub loadingView = (ViewStub)view.findViewById(R.id.com_telenor_connect_loading_view);
        Bundle arguments = this.getArguments();
        int loadingScreenResource = arguments.getInt("com.telenor.connect.CUSTOM_LOADING_SCREEN_EXTRA", R.layout.com_telenor_connect_default_loading_view);
        loadingView.setLayoutResource(loadingScreenResource);
        loadingView.inflate();
        loadingView.setVisibility(0);
        String pageUrl = HeFlowDecider.chooseFlow(Uri.parse((String)ConnectUrlHelper.getPageUrl(arguments)), this.getContext()).toString();
        WebErrorView webErrorView = (WebErrorView)view.findViewById(R.id.com_telenor_connect_error_view);
        this.setupErrorView(this.webView, loadingView, pageUrl, webErrorView, view);
        this.client = new ConnectWebViewClient((Activity)this.getActivity(), this.webView, (View)loadingView, webErrorView, new ParseTokenCallback(this.callback));
        WebViewHelper.setupWebView(this.webView, this.client, pageUrl);
        return view;
    }

    private void setupErrorView(final WebView webView, final ViewStub loadingView, final String pageUrl, final WebErrorView errorView, final View view) {
        final View loadingSpinner = errorView.getLoadingSpinner();
        final Button tryAgain = errorView.getTryAgainButton();
        tryAgain.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                loadingSpinner.setVisibility(0);
                tryAgain.setEnabled(false);
                view.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        loadingSpinner.setVisibility(4);
                        tryAgain.setEnabled(true);
                        errorView.setVisibility(8);
                        loadingView.setVisibility(0);
                        webView.loadUrl(pageUrl);
                    }
                }, 1000L);
            }
        });
    }

    public void onPause() {
        super.onPause();
        this.webView.onPause();
    }

    public void onResume() {
        super.onResume();
        this.webView.onResume();
    }
}

