/*
 * Decompiled with CFR 0.152.
 */
package com.telenor.connect;

import android.annotation.SuppressLint;
import android.content.Context;
import com.google.gson.Gson;
import com.telenor.connect.WellKnownAPI;

public class WellKnownConfigStore {
    private static final String PREFERENCE_KEY_WELL_KNOWN_CONFIG = "WELL_KNOWN_CONFIG";
    private final Gson preferencesGson = new Gson();
    private final Context context;

    public WellKnownConfigStore(Context context) {
        this.context = context;
    }

    public void set(WellKnownAPI.WellKnownConfig wellKnownConfig) {
        String jsonWellKnownConfig = this.preferencesGson.toJson((Object)wellKnownConfig);
        this.context.getSharedPreferences("com.telenor.connect.PREFERENCES_FILE", 0).edit().putString(PREFERENCE_KEY_WELL_KNOWN_CONFIG, jsonWellKnownConfig).apply();
    }

    @SuppressLint(value={"ApplySharedPref"})
    public void clearSynchronously() {
        this.context.getSharedPreferences("com.telenor.connect.PREFERENCES_FILE", 0).edit().remove(PREFERENCE_KEY_WELL_KNOWN_CONFIG).commit();
    }

    public WellKnownAPI.WellKnownConfig get() {
        if (this.context == null) {
            return null;
        }
        String wellKnownConfigJson = this.context.getSharedPreferences("com.telenor.connect.PREFERENCES_FILE", 0).getString(PREFERENCE_KEY_WELL_KNOWN_CONFIG, null);
        return (WellKnownAPI.WellKnownConfig)this.preferencesGson.fromJson(wellKnownConfigJson, WellKnownAPI.WellKnownConfig.class);
    }
}

