/*
 * Decompiled with CFR 0.152.
 */
package com.telenor.connect.headerenrichment;

import android.os.AsyncTask;
import android.os.Handler;
import android.util.Log;
import androidx.annotation.RequiresApi;
import com.telenor.connect.ConnectSdk;
import com.telenor.connect.headerenrichment.HeTokenResponse;
import com.telenor.connect.headerenrichment.MobileDataFetcher;
import java.util.Calendar;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

public class GetHeaderEnrichmentGifTask
extends AsyncTask<Void, Void, HeTokenResponse> {
    private final String url;
    private final long timeout;

    public GetHeaderEnrichmentGifTask(String url, long timeout) {
        this.url = url;
        this.timeout = timeout;
    }

    protected void onPreExecute() {
        super.onPreExecute();
        Handler handler = new Handler();
        handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (GetHeaderEnrichmentGifTask.this.getStatus() == AsyncTask.Status.RUNNING) {
                    GetHeaderEnrichmentGifTask.this.cancel(true);
                }
            }
        }, this.timeout);
    }

    @RequiresApi(api=21)
    protected HeTokenResponse doInBackground(Void ... voids) {
        String fetchedTokenResponse = MobileDataFetcher.fetchUrlThroughCellular(this.url);
        if (fetchedTokenResponse == null) {
            return null;
        }
        HeTokenResponse heTokenResponse = GetHeaderEnrichmentGifTask.convertHeTokenResponse(fetchedTokenResponse);
        if (heTokenResponse == null) {
            return null;
        }
        String fetchedGifResponse = MobileDataFetcher.fetchUrlThroughCellular(heTokenResponse.getGifUrl());
        if (fetchedGifResponse == null) {
            return null;
        }
        return heTokenResponse;
    }

    private static HeTokenResponse convertHeTokenResponse(String heTokenResponse) {
        int exp;
        String token;
        String gifUrl;
        try {
            JSONObject jsonResponse = new JSONObject(heTokenResponse);
            gifUrl = jsonResponse.getString("gifUrl");
            token = jsonResponse.getString("heToken");
            exp = jsonResponse.getInt("exp");
        }
        catch (JSONException e) {
            Log.e((String)"ConnectSDK", (String)"Failed to parse header-enrichment-token", (Throwable)e);
            ConnectSdk.sendAnalyticsData(e);
            return null;
        }
        Calendar instance = Calendar.getInstance();
        instance.add(14, exp);
        Date expiration = instance.getTime();
        return new HeTokenResponse(token, expiration, gifUrl);
    }
}

