/*
 * Decompiled with CFR 0.152.
 */
package com.telenor.connect.headerenrichment;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.os.Build;
import androidx.annotation.RequiresApi;
import com.telenor.connect.ConnectSdk;
import com.telenor.connect.headerenrichment.DismissDialogCallback;
import com.telenor.connect.headerenrichment.GetHeaderEnrichmentGifTask;
import com.telenor.connect.headerenrichment.HeTokenCallback;
import com.telenor.connect.headerenrichment.HeTokenResponse;
import com.telenor.connect.headerenrichment.ShowLoadingCallback;
import com.telenor.connect.id.IdProvider;
import com.telenor.connect.utils.ConnectUrlHelper;
import java.util.Date;
import java.util.Map;

public class HeLogic {
    public static final boolean canNotDirectNetworkTraffic = Build.VERSION.SDK_INT < 21;
    private static final long HE_TOKEN_TIMEOUT_MILLISECONDS = 10000L;
    private static boolean heWasInitialized = false;
    private static boolean heTokenSuccess = true;
    private static HeTokenCallback heTokenCallback;
    private static boolean isHeTokenRequestOngoing;
    private static HeTokenResponse heTokenResponse;
    private static ConnectivityManager connectivityManager;
    private static volatile Network cellularNetwork;
    private static volatile Network defaultNetwork;
    private static int numberOfNetworkTogglesCouldHappened;

    public static void initializeNetworks(Context context) {
        connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
    }

    public static void runInstantVerification(IdProvider provider, boolean useStaging) {
        boolean connectivityManagerAvailableAndNotTooOldAndroid;
        ConnectSdk.instantVerificationCallHappened();
        boolean bl = connectivityManagerAvailableAndNotTooOldAndroid = connectivityManager != null && Build.VERSION.SDK_INT >= 21;
        if (connectivityManagerAvailableAndNotTooOldAndroid) {
            HeLogic.initializeCellularNetwork(provider, useStaging);
            HeLogic.initializeDefaultNetwork();
        }
    }

    @TargetApi(value=21)
    private static void initializeCellularNetwork(final IdProvider provider, final boolean useStaging) {
        ConnectivityManager.NetworkCallback cellularNetworkCallback = new ConnectivityManager.NetworkCallback(){

            public void onAvailable(Network network) {
                boolean noSignedInUser;
                cellularNetwork = network;
                boolean bl = noSignedInUser = ConnectSdk.getAccessToken() == null;
                if (noSignedInUser) {
                    HeLogic.initializeHeaderEnrichment(provider, useStaging, ConnectSdk.getLogSessionId());
                }
            }
        };
        HeLogic.registerCellularNetworkCallback(cellularNetworkCallback);
    }

    @RequiresApi(api=21)
    public static void registerCellularNetworkCallback(ConnectivityManager.NetworkCallback cellularNetworkCallback) {
        NetworkRequest cellularNetworkRequest = HeLogic.getCellularNetworkRequest();
        try {
            connectivityManager.requestNetwork(cellularNetworkRequest, cellularNetworkCallback);
        }
        catch (SecurityException e) {
            cellularNetwork = null;
        }
    }

    @RequiresApi(api=21)
    public static void unRegisterCellularNetworkCallback(ConnectivityManager.NetworkCallback cellularNetworkCallback) {
        try {
            connectivityManager.unregisterNetworkCallback(cellularNetworkCallback);
        }
        catch (SecurityException e) {
            cellularNetwork = null;
        }
    }

    @RequiresApi(api=21)
    private static NetworkRequest getCellularNetworkRequest() {
        return new NetworkRequest.Builder().addCapability(12).addTransportType(0).build();
    }

    private static boolean initializeHeaderEnrichment(IdProvider provider, boolean useStaging, String logSessionId) {
        if (heWasInitialized) {
            ++numberOfNetworkTogglesCouldHappened;
        }
        if (canNotDirectNetworkTraffic || heWasInitialized) {
            return false;
        }
        heWasInitialized = true;
        String url = ConnectUrlHelper.getHeApiUrl(provider, useStaging, logSessionId);
        GetHeaderEnrichmentGifTask getGifTask = new GetHeaderEnrichmentGifTask(url, 10000L){

            @Override
            protected void onPreExecute() {
                isHeTokenRequestOngoing = true;
                super.onPreExecute();
            }

            protected void onPostExecute(HeTokenResponse heToken) {
                HeLogic.handleHeTokenResult(heToken);
            }

            protected void onCancelled(HeTokenResponse heToken) {
                HeLogic.handleHeTokenResult(heToken);
            }
        };
        getGifTask.execute(new Void[0]);
        return true;
    }

    @TargetApi(value=21)
    private static void initializeDefaultNetwork() {
        NetworkRequest networkRequest = new NetworkRequest.Builder().addCapability(12).build();
        try {
            connectivityManager.requestNetwork(networkRequest, new ConnectivityManager.NetworkCallback(){

                public void onAvailable(Network network) {
                    defaultNetwork = network;
                }
            });
        }
        catch (SecurityException e) {
            defaultNetwork = null;
        }
    }

    public static void handleHeToken(Map<String, String> parameters, ShowLoadingCallback showLoadingCallback, HeTokenCallback heTokenCallback, String logSessionId, IdProvider provider, boolean useStaging, DismissDialogCallback dismissDialogCallback) {
        boolean tokenIsExpired;
        boolean authenticateNow;
        boolean finishedUnSuccessfully = !heTokenSuccess && !isHeTokenRequestOngoing;
        boolean promptBlocksUseOfHe = parameters.containsKey("prompt") && "no_seam".equals(parameters.get("prompt"));
        boolean bl = authenticateNow = finishedUnSuccessfully || promptBlocksUseOfHe || canNotDirectNetworkTraffic;
        if (authenticateNow) {
            HeLogic.callCallbacks(showLoadingCallback, heTokenCallback, dismissDialogCallback);
            return;
        }
        if (isHeTokenRequestOngoing) {
            HeLogic.setFutureHeTokenCallback(parameters, showLoadingCallback, heTokenCallback, logSessionId, provider, useStaging, dismissDialogCallback);
            return;
        }
        boolean heWasNeverInitialized = heTokenSuccess && heTokenResponse == null;
        boolean bl2 = tokenIsExpired = heTokenResponse != null && new Date().after(heTokenResponse.getExpiration());
        if (heWasNeverInitialized || tokenIsExpired) {
            HeLogic.setFutureHeTokenCallback(parameters, showLoadingCallback, heTokenCallback, logSessionId, provider, useStaging, dismissDialogCallback);
            HeLogic.runInstantVerification(provider, useStaging);
            if (!HeLogic.initializeHeaderEnrichment(provider, useStaging, logSessionId)) {
                HeLogic.handleHeTokenResult(null);
            }
            return;
        }
        HeLogic.callCallbacks(showLoadingCallback, heTokenCallback, dismissDialogCallback);
    }

    private static void callCallbacks(ShowLoadingCallback showLoadingCallback, HeTokenCallback heTokenCallback, DismissDialogCallback dismissDialogCallback) {
        if (showLoadingCallback != null) {
            showLoadingCallback.stop();
        }
        if (dismissDialogCallback != null) {
            dismissDialogCallback.dismiss();
        }
        heTokenCallback.done();
    }

    private static void setFutureHeTokenCallback(final Map<String, String> parameters, final ShowLoadingCallback showLoadingCallback, final HeTokenCallback heTokenCallback, final String logSessionId, final IdProvider provider, final boolean useStaging, final DismissDialogCallback dismissDialogCallback) {
        HeLogic.heTokenCallback = new HeTokenCallback(){

            @Override
            public void done() {
                heTokenCallback = null;
                HeLogic.handleHeToken(parameters, showLoadingCallback, heTokenCallback, logSessionId, provider, useStaging, dismissDialogCallback);
            }
        };
    }

    private static void handleHeTokenResult(HeTokenResponse heTokenResponse) {
        isHeTokenRequestOngoing = false;
        HeLogic.heTokenResponse = heTokenResponse;
        boolean bl = heTokenSuccess = heTokenResponse != null;
        if (heTokenCallback != null) {
            heTokenCallback.done();
        }
    }

    public static boolean failedToGetToken() {
        return !heTokenSuccess || heTokenResponse == null;
    }

    public static HeTokenResponse getHeTokenResponse() {
        return heTokenResponse;
    }

    public static boolean isCellularDataNetworkConnected() {
        NetworkInfo networkInfo;
        if (connectivityManager == null) {
            return false;
        }
        if (canNotDirectNetworkTraffic) {
            networkInfo = HeLogic.getCellularNetworkInfo();
        } else {
            if (cellularNetwork == null) {
                return false;
            }
            networkInfo = connectivityManager.getNetworkInfo(cellularNetwork);
        }
        return networkInfo != null && networkInfo.isConnected();
    }

    public static NetworkInfo getCellularNetworkInfo() {
        if (connectivityManager == null) {
            return null;
        }
        return connectivityManager.getNetworkInfo(0);
    }

    public static boolean isCellularDataNetworkDefault() {
        if (connectivityManager == null) {
            return false;
        }
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.getType() == 0;
    }

    public static NetworkInfo getActiveNetworkInfo() {
        if (connectivityManager == null) {
            return null;
        }
        return connectivityManager.getActiveNetworkInfo();
    }

    @TargetApi(value=21)
    public static Network getCellularNetwork() {
        return cellularNetwork;
    }

    @TargetApi(value=21)
    public static Network getDefaultNetwork() {
        return defaultNetwork;
    }

    public static int getNumberOfNetworkTogglesCouldHappened() {
        return numberOfNetworkTogglesCouldHappened;
    }

    static {
        numberOfNetworkTogglesCouldHappened = 0;
    }
}

