/*
 * Decompiled with CFR 0.152.
 */
package com.telenor.connect.utils;

import android.annotation.SuppressLint;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import okhttp3.Headers;

public class HeadersDateUtil {
    @SuppressLint(value={"SimpleDateFormat"})
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);

    @Nullable
    public static Date extractDate(@NonNull Headers headers) {
        for (String name : headers.names()) {
            if (!"Date".equalsIgnoreCase(name)) continue;
            try {
                return DATE_FORMAT.parse(headers.get(name));
            }
            catch (ParseException e) {
                Log.w((String)"ConnectSDK", (String)("Failed to call parse Date from headers. headers=" + headers), (Throwable)e);
                return null;
            }
        }
        return null;
    }
}

