/*
 * Decompiled with CFR 0.152.
 */
package com.telenor.connect.ui;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.view.View;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.annotation.RequiresApi;
import com.telenor.connect.ConnectCallback;
import com.telenor.connect.ConnectSdk;
import com.telenor.connect.headerenrichment.HeLogic;
import com.telenor.connect.headerenrichment.MobileDataFetcher;
import com.telenor.connect.sms.SmsBroadcastReceiver;
import com.telenor.connect.sms.SmsHandler;
import com.telenor.connect.sms.SmsPinParseUtil;
import com.telenor.connect.sms.SmsRetrieverUtil;
import com.telenor.connect.ui.Instruction;
import com.telenor.connect.ui.InstructionHandler;
import com.telenor.connect.ui.WebErrorView;
import com.telenor.connect.utils.ConnectUtils;
import com.telenor.connect.utils.JavascriptUtil;
import java.util.List;
import java.util.regex.Pattern;

public class ConnectWebViewClient
extends WebViewClient
implements SmsHandler,
InstructionHandler {
    private static final int DELAY_HIDE_NATIVE_LOADING_VIEW = 50;
    private static final Pattern TD_HTTPS_PATTERN = Pattern.compile("^https://.*telenordigital.com(?:$|/)");
    private static final String JAVASCRIPT_PROCESSES_INSTRUCTIONS = "javascript:if (document.getElementById('android-instructions') !== null) {window.AndroidInterface.processInstructions(document.getElementById('android-instructions').innerHTML)}";
    private final Activity activity;
    private final View loadingView;
    private final WebErrorView errorView;
    private final WebView webView;
    private final ConnectCallback connectCallback;
    private boolean waitingForPinSms = false;
    private boolean instructionsReceived;
    private Instruction callbackInstruction;
    private String savedSmsBody;
    private SmsBroadcastReceiver smsBroadcastReceiver;

    public ConnectWebViewClient(Activity activity, WebView webView, View loadingView, WebErrorView errorView, ConnectCallback callback) {
        this.webView = webView;
        this.activity = activity;
        this.loadingView = loadingView;
        this.errorView = errorView;
        this.connectCallback = callback;
        SmsRetrieverUtil.startSmsRetriever((Context)activity);
        this.smsBroadcastReceiver = new SmsBroadcastReceiver(this);
        activity.registerReceiver((BroadcastReceiver)this.smsBroadcastReceiver, SmsRetrieverUtil.SMS_FILTER);
    }

    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        if (ConnectSdk.getRedirectUri() != null && url.startsWith(ConnectSdk.getRedirectUri())) {
            ConnectUtils.parseAuthCode(url, this.getOriginalState(), this.connectCallback);
            return true;
        }
        return false;
    }

    private String getOriginalState() {
        String url = this.activity.getIntent().getStringExtra("com.telenor.connect.LOGIN_AUTH_URI");
        return Uri.parse((String)url).getQueryParameter("state");
    }

    @TargetApi(value=21)
    public WebResourceResponse shouldInterceptRequest(WebView view, WebResourceRequest request) {
        if (!HeLogic.isCellularDataNetworkConnected() || HeLogic.isCellularDataNetworkDefault()) {
            return null;
        }
        if (MobileDataFetcher.shouldFetchThroughCellular(request.getUrl().toString())) {
            return MobileDataFetcher.fetchWebResourceResponse(request.getUrl().toString(), true);
        }
        return null;
    }

    @RequiresApi(api=23)
    public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
        super.onReceivedError(view, request, error);
        String errorText = error.getDescription() + " (" + error.getErrorCode() + ")";
        this.errorView.setErrorText(errorText, request.getUrl().toString());
        this.errorView.setVisibility(0);
    }

    public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        super.onReceivedError(view, errorCode, description, failingUrl);
        String errorText = description + " (" + errorCode + ")";
        this.errorView.setErrorText(errorText, failingUrl);
        this.errorView.setVisibility(0);
    }

    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        this.hideLoadingViewWithDelayIfHEILoading(url);
        this.instructionsReceived = false;
        super.onPageStarted(view, url, favicon);
    }

    private void hideLoadingViewWithDelayIfHEILoading(String url) {
        if (url != null && url.endsWith("/heidetect") && this.loadingView.getVisibility() == 0) {
            this.loadingView.postDelayed(new Runnable(){

                @Override
                public void run() {
                    ConnectWebViewClient.this.loadingView.setVisibility(8);
                }
            }, 50L);
        }
    }

    public void onPageFinished(WebView view, String url) {
        super.onPageFinished(view, url);
        this.loadingView.setVisibility(8);
        if (!this.instructionsReceived && this.shouldCheckPageForInstructions(url)) {
            this.webView.loadUrl(JAVASCRIPT_PROCESSES_INSTRUCTIONS);
        }
    }

    private boolean shouldCheckPageForInstructions(String url) {
        return TD_HTTPS_PATTERN.matcher(url).find();
    }

    @Override
    public void givenInstructions(List<Instruction> instructions) {
        if (this.instructionsReceived) {
            return;
        }
        this.instructionsReceived = true;
        if (this.containsSmsInstruction(instructions)) {
            this.executeInstructions(instructions);
        }
    }

    private boolean containsSmsInstruction(List<Instruction> instructions) {
        for (Instruction instruction : instructions) {
            if (!instruction.getName().equals("androidSystemCall_getPinFromSms")) continue;
            return true;
        }
        return false;
    }

    private void executeInstructions(List<Instruction> instructions) {
        for (Instruction instruction : instructions) {
            if (instruction.getName().equals("androidSystemCall_getPinFromSms")) {
                this.getPinFromSms(instruction);
                continue;
            }
            this.runJavascriptInstruction(instruction);
        }
    }

    private void runJavascriptInstruction(final Instruction instruction) {
        this.webView.post(new Runnable(){

            @Override
            public void run() {
                String javascript = JavascriptUtil.getJavascriptString(instruction);
                ConnectWebViewClient.this.webView.loadUrl("javascript:" + javascript);
            }
        });
    }

    private void getPinFromSms(Instruction instruction) {
        this.callbackInstruction = instruction;
        this.waitingForPinSms = true;
        this.handleIfSmsAlreadyArrived();
    }

    private void stopWaitingForPin() {
        this.waitingForPinSms = false;
        this.savedSmsBody = null;
        this.callbackInstruction = null;
        this.activity.unregisterReceiver((BroadcastReceiver)this.smsBroadcastReceiver);
    }

    private void handleIfSmsAlreadyArrived() {
        if (this.savedSmsBody == null) {
            return;
        }
        this.webView.post(new Runnable(){

            @Override
            public void run() {
                ConnectWebViewClient.this.receivedSms(ConnectWebViewClient.this.savedSmsBody);
            }
        });
    }

    private synchronized void handlePinFromSmsBodyIfPresent(String body, final Instruction instruction) {
        final String foundPin = SmsPinParseUtil.findPin(body, instruction);
        if (this.waitingForPinSms && foundPin != null && instruction.getPinCallbackName() != null) {
            this.stopWaitingForPin();
            this.webView.post(new Runnable(){

                @Override
                public void run() {
                    String javascript = JavascriptUtil.getJavascriptString(instruction.getPinCallbackName(), "'" + foundPin + "'");
                    ConnectWebViewClient.this.webView.loadUrl("javascript:" + javascript);
                }
            });
        }
    }

    @Override
    public void receivedSms(String messageBody) {
        if (this.callbackInstruction == null) {
            this.savedSmsBody = messageBody;
            return;
        }
        this.handlePinFromSmsBodyIfPresent(messageBody, this.callbackInstruction);
    }
}

