/*
 * Decompiled with CFR 0.152.
 */
package com.telenor.connect.ui;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.browser.customtabs.CustomTabsCallback;
import androidx.browser.customtabs.CustomTabsClient;
import androidx.browser.customtabs.CustomTabsServiceConnection;
import androidx.browser.customtabs.CustomTabsSession;
import androidx.fragment.app.FragmentActivity;
import com.telenor.connect.BrowserType;
import com.telenor.connect.ConnectSdk;
import com.telenor.connect.ui.ConnectWebViewLoginButton;
import com.telenor.connect.utils.ConnectUrlHelper;
import com.telenor.connect.utils.CustomTabsHelper;
import java.lang.ref.WeakReference;

class ConnectCustomTabLoginButton
extends ConnectWebViewLoginButton {
    private static final Uri PRE_FETCH_URL = Uri.parse((String)ConnectUrlHelper.getConnectApiUrl().newBuilder().addPathSegment("id").addPathSegment("android-sdk-prefetch-static-resources").build().uri().toString());
    private CustomTabsServiceConnection connection;
    private boolean customTabsSupported = false;
    private boolean serviceBound = false;
    private BrowserType browserType;
    private CustomTabsSession session;

    public ConnectCustomTabLoginButton(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    @Override
    protected void authenticate() {
        if (!this.customTabsSupported) {
            super.authenticate();
            return;
        }
        ConnectSdk.authenticate(this.session, this.getParameters(), this.browserType, this.getActivity(), this.getShowLoadingCallback(), this.getDismissDialogCallback());
    }

    private static boolean contextIntentFilterMatchesRedirectUri(Context context) {
        PackageManager manager;
        Uri parse = Uri.parse((String)ConnectSdk.getRedirectUri());
        Intent intent = new Intent().setData(parse);
        ComponentName componentName = intent.resolveActivity(manager = context.getPackageManager());
        if (componentName == null) {
            return false;
        }
        return context.getPackageName().equals(componentName.getPackageName());
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!(this.getActivity() instanceof FragmentActivity)) {
            throw new ClassCastException(this.getActivity().toString() + " must be a FragmentActivity");
        }
        String packageNameToUse = CustomTabsHelper.getPackageNameToUse(this.getContext());
        if (TextUtils.isEmpty((CharSequence)packageNameToUse)) {
            return;
        }
        this.connection = new WeakReferenceCustomTabsServiceConnection(new WeakReference<ConnectCustomTabLoginButton>(this));
        this.serviceBound = CustomTabsClient.bindCustomTabsService((Context)this.getContext(), (String)packageNameToUse, (CustomTabsServiceConnection)this.connection);
        boolean correctIntentFilter = ConnectCustomTabLoginButton.contextIntentFilterMatchesRedirectUri(this.getContext());
        this.customTabsSupported = this.serviceBound && correctIntentFilter;
        this.browserType = this.customTabsSupported ? BrowserType.CHROME_CUSTOM_TAB : BrowserType.WEB_VIEW;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.serviceBound) {
            this.getContext().unbindService((ServiceConnection)this.connection);
            this.serviceBound = false;
        }
        if (this.connection != null) {
            this.connection = null;
        }
    }

    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        Intent intent = this.getActivity().getIntent();
        if (ConnectSdk.hasErrorRedirectUrlCall(intent)) {
            ConnectSdk.setRandomLogSessionId();
        }
    }

    private void setSession(CustomTabsSession session) {
        this.session = session;
    }

    private static class WeakReferenceCustomTabsCallback
    extends CustomTabsCallback {
        private final WeakReference<ConnectCustomTabLoginButton> weakButton;

        WeakReferenceCustomTabsCallback(WeakReference<ConnectCustomTabLoginButton> weakButton) {
            this.weakButton = weakButton;
        }

        public void onNavigationEvent(int navigationEvent, Bundle extras) {
            ConnectCustomTabLoginButton connectCustomTabLoginButton = (ConnectCustomTabLoginButton)this.weakButton.get();
            if (connectCustomTabLoginButton == null) {
                return;
            }
            switch (navigationEvent) {
                case 6: {
                    connectCustomTabLoginButton.setEnabled(true);
                    return;
                }
                case 5: {
                    connectCustomTabLoginButton.setEnabled(false);
                    return;
                }
            }
        }
    }

    private static class WeakReferenceCustomTabsServiceConnection
    extends CustomTabsServiceConnection {
        private final WeakReference<ConnectCustomTabLoginButton> weakButton;

        WeakReferenceCustomTabsServiceConnection(WeakReference<ConnectCustomTabLoginButton> weakButton) {
            this.weakButton = weakButton;
        }

        public void onCustomTabsServiceConnected(ComponentName name, CustomTabsClient client) {
            ConnectCustomTabLoginButton connectCustomTabLoginButton = (ConnectCustomTabLoginButton)this.weakButton.get();
            if (connectCustomTabLoginButton == null) {
                return;
            }
            client.warmup(0L);
            CustomTabsSession session = client.newSession((CustomTabsCallback)new WeakReferenceCustomTabsCallback(this.weakButton));
            connectCustomTabLoginButton.setSession(session);
            if (session != null) {
                session.mayLaunchUrl(PRE_FETCH_URL, null, null);
            }
        }

        public void onServiceDisconnected(ComponentName name) {
        }
    }
}

