package com.telenor.connect.sms;

import android.content.Context;
import android.content.IntentFilter;
import android.util.Log;

import com.google.android.gms.auth.api.phone.SmsRetriever;
import com.google.android.gms.auth.api.phone.SmsRetrieverClient;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.Task;
import com.telenor.connect.utils.ConnectUtils;

import androidx.annotation.NonNull;

public class SmsRetrieverUtil {
    public static final IntentFilter SMS_FILTER = new IntentFilter(SmsRetriever.SMS_RETRIEVED_ACTION);

    public static void startSmsRetriever(Context context) {
        SmsRetrieverClient client = SmsRetriever.getClient(context);
        Task<Void> task = client.startSmsRetriever();
        task.addOnSuccessListener(new OnSuccessListener<Void>() {
            @Override
            public void onSuccess(Void aVoid) {
                Log.i(ConnectUtils.LOG_TAG, "Successfully started sms retriever api client");
            }
        });
        task.addOnFailureListener(new OnFailureListener() {
            @Override
            public void onFailure(@NonNull Exception e) {
                Log.e(ConnectUtils.LOG_TAG, "Failed to start sms retriever api client");
            }
        });
    }
}
