/*
 * Decompiled with CFR 0.152.
 */
package com.telenor.connect.ui;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import com.telenor.connect.ConnectSdk;
import com.telenor.connect.R;
import com.telenor.connect.headerenrichment.DismissDialogCallback;
import com.telenor.connect.headerenrichment.ShowLoadingCallback;
import com.telenor.connect.id.Claims;
import com.telenor.connect.ui.AuthenticationButton;
import com.telenor.connect.ui.ConnectButton;
import com.telenor.connect.utils.ClaimsParameterFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class ConnectWebViewLoginButton
extends ConnectButton
implements AuthenticationButton {
    public static final int NO_CUSTOM_LAYOUT = -1;
    private ArrayList<String> acrValues;
    private Map<String, String> loginParameters;
    private ArrayList<String> loginScopeTokens;
    private int requestCode = 43399;
    private Claims claims;
    private int customLoadingLayout = -1;
    private ShowLoadingCallback showLoadingCallback;
    private DismissDialogCallback dismissDialogCallback;
    private View.OnClickListener onClickListener;

    public ConnectWebViewLoginButton(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.setText(R.string.com_telenor_connect_login_button_text);
        this.onClickListener = new View.OnClickListener(){

            public void onClick(View v) {
                ConnectWebViewLoginButton.this.authenticate();
            }
        };
        this.setOnClickListener(this.onClickListener);
    }

    @Override
    public ArrayList<String> getAcrValues() {
        return this.acrValues;
    }

    @Override
    public Map<String, String> getLoginParameters() {
        return this.loginParameters;
    }

    @Override
    public ArrayList<String> getLoginScopeTokens() {
        return this.loginScopeTokens;
    }

    @Override
    public int getRequestCode() {
        return this.requestCode;
    }

    @Override
    public Claims getClaims() {
        return this.claims;
    }

    @Override
    public int getCustomLoadingLayout() {
        return this.customLoadingLayout;
    }

    @Override
    public View.OnClickListener getOnClickListener() {
        return this.onClickListener;
    }

    @Override
    public void setAcrValues(String ... acrValues) {
        this.acrValues = new ArrayList<String>(Arrays.asList(acrValues));
    }

    @Override
    public void setAcrValues(ArrayList<String> acrValues) {
        this.acrValues = acrValues;
    }

    @Override
    public void setLoginScopeTokens(String ... scopeTokens) {
        this.loginScopeTokens = new ArrayList<String>(Arrays.asList(scopeTokens));
    }

    @Override
    public void setLoginScopeTokens(ArrayList<String> scopeTokens) {
        this.loginScopeTokens = scopeTokens;
    }

    @Override
    public void setExtraLoginParameters(Map<String, String> parameters) {
        this.loginParameters = parameters;
    }

    @Override
    public void setRequestCode(int requestCode) {
        this.requestCode = requestCode;
    }

    @Override
    public void setClaims(Claims claims) {
        this.claims = claims;
    }

    @Override
    public void setCustomLoadingLayout(int customLoadingLayout) {
        this.customLoadingLayout = customLoadingLayout;
    }

    @NonNull
    protected Map<String, String> getParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (this.getAcrValues() != null && !this.getAcrValues().isEmpty()) {
            parameters.put("acr_values", TextUtils.join((CharSequence)" ", this.getAcrValues()));
        }
        if (this.getLoginScopeTokens() != null && !this.getLoginScopeTokens().isEmpty()) {
            parameters.put("scope", TextUtils.join((CharSequence)" ", this.getLoginScopeTokens()));
        }
        this.addClaims(parameters);
        if (this.getLoginParameters() != null && !this.getLoginParameters().isEmpty()) {
            parameters.putAll(this.getLoginParameters());
        }
        return parameters;
    }

    private void addClaims(Map<String, String> parameters) {
        if (this.getClaims() != null && this.getClaims().getClaimsAsSet() != null) {
            parameters.put("claims", ClaimsParameterFormatter.asJson(this.getClaims()));
        }
    }

    protected void authenticate() {
        ConnectSdk.authenticate(this.getActivity(), this.getParameters(), this.getCustomLoadingLayout(), this.getRequestCode(), this.getShowLoadingCallback(), this.getDismissDialogCallback());
    }

    public ShowLoadingCallback getShowLoadingCallback() {
        return this.showLoadingCallback;
    }

    public void setShowLoadingCallback(ShowLoadingCallback showLoadingCallback) {
        this.showLoadingCallback = showLoadingCallback;
    }

    public void setDismissDialogCallback(DismissDialogCallback dismissDialogCallback) {
        this.dismissDialogCallback = dismissDialogCallback;
    }

    public DismissDialogCallback getDismissDialogCallback() {
        return this.dismissDialogCallback;
    }
}

