/*
 * Decompiled with CFR 0.152.
 */
package com.telenor.connect.ui;

import android.content.BroadcastReceiver;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Configuration;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import com.google.gson.Gson;
import com.telenor.connect.ConnectCallback;
import com.telenor.connect.ConnectSdk;
import com.telenor.connect.R;
import com.telenor.connect.id.ConnectTokens;
import com.telenor.connect.ui.ConnectWebFragment;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ConnectActivity
extends FragmentActivity
implements ConnectCallback {
    private final Gson gson = new Gson();
    private Fragment singleFragment;
    private Set<BroadcastReceiver> receivers = new HashSet<BroadcastReceiver>();

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.com_telenor_connect_activity_layout);
        FragmentManager manager = this.getSupportFragmentManager();
        String fragmentTag = "SingleFragment";
        Fragment fragment = manager.findFragmentByTag("SingleFragment");
        Intent intent = this.getIntent();
        String action = intent.getAction();
        int loadingScreen = intent.getIntExtra("com.telenor.connect.CUSTOM_LOADING_SCREEN_EXTRA", R.layout.com_telenor_connect_default_loading_view);
        if (fragment == null) {
            fragment = new ConnectWebFragment();
            Bundle bundle = new Bundle(intent.getExtras());
            bundle.putString("com.telenor.connect.ACTION_ARGUMENT", action);
            bundle.putInt("com.telenor.connect.CUSTOM_LOADING_SCREEN_EXTRA", loadingScreen);
            fragment.setArguments(bundle);
            fragment.setRetainInstance(true);
            manager.beginTransaction().add(R.id.com_telenor_connect_fragment_container, fragment, "SingleFragment").commit();
        }
        this.singleFragment = fragment;
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (this.singleFragment != null) {
            this.singleFragment.onConfigurationChanged(newConfig);
        }
    }

    @Override
    public void onSuccess(Object successData) {
        if (ConnectSdk.isConfidentialClient()) {
            Map authCodeData = (Map)successData;
            Intent intent = new Intent();
            for (Map.Entry entry : authCodeData.entrySet()) {
                intent.putExtra((String)entry.getKey(), (String)entry.getValue());
            }
            this.setResult(-1, intent);
            this.finish();
        } else {
            ConnectTokens connectTokens = (ConnectTokens)successData;
            Intent data = new Intent();
            String json = this.gson.toJson((Object)connectTokens);
            data.putExtra("com.telenor.connect.EXTRA_CONNECT_TOKENS", json);
            this.setResult(-1, data);
            this.finish();
        }
    }

    @Override
    public void onError(Object errorData) {
        ConnectSdk.setRandomLogSessionId();
        Intent intent = new Intent();
        if (errorData instanceof Map) {
            Map authCodeData = (Map)errorData;
            for (Map.Entry entry : authCodeData.entrySet()) {
                intent.putExtra((String)entry.getKey(), (String)entry.getValue());
            }
        }
        this.setResult(0, intent);
        this.finish();
    }

    public Intent registerReceiver(BroadcastReceiver receiver, IntentFilter filter) {
        this.receivers.add(receiver);
        return super.registerReceiver(receiver, filter);
    }

    protected void onDestroy() {
        super.onDestroy();
        Iterator<BroadcastReceiver> iterator = this.receivers.iterator();
        while (iterator.hasNext()) {
            try {
                this.unregisterReceiver(iterator.next());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            iterator.remove();
        }
    }
}

