/*
 * Decompiled with CFR 0.152.
 */
package com.telenor.connect.id;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.support.v4.content.LocalBroadcastManager;
import com.telenor.connect.ConnectSdk;
import com.telenor.connect.id.CurrentTokenStateBroadcastReceiver;
import com.telenor.connect.utils.Validator;

public abstract class ConnectTokensStateTracker {
    private static final IntentFilter loginStateChangedFilter = new IntentFilter("com.telenor.connect.ACTION_LOGIN_STATE_CHANGED");
    private final BroadcastReceiver receiver;
    private final LocalBroadcastManager broadcastManager;
    private boolean isTracking = false;

    protected abstract void onTokenStateChanged(boolean var1);

    public ConnectTokensStateTracker() {
        Validator.sdkInitialized();
        this.receiver = new CurrentTokenStateBroadcastReceiver(this);
        this.broadcastManager = LocalBroadcastManager.getInstance((Context)ConnectSdk.getContext());
        this.startTrackingAccessToken();
    }

    public void startTrackingAccessToken() {
        if (this.isTracking) {
            return;
        }
        this.addBroadcastReceiver();
        this.isTracking = true;
    }

    public void stopTrackingAccessToken() {
        if (!this.isTracking) {
            return;
        }
        this.broadcastManager.unregisterReceiver(this.receiver);
        this.isTracking = false;
    }

    public boolean isTracking() {
        return this.isTracking;
    }

    private void addBroadcastReceiver() {
        this.broadcastManager.registerReceiver(this.receiver, loginStateChangedFilter);
    }
}

