/*
 * Decompiled with CFR 0.152.
 */
package com.telenor.connect;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.gson.annotations.SerializedName;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import retrofit2.Call;
import retrofit2.http.GET;
import retrofit2.http.Headers;

public interface WellKnownAPI {
    @Headers(value={"Content-Type: application/json"})
    @GET(value="/oauth/.well-known/openid-configuration")
    public Call<WellKnownConfig> getWellKnownConfig();

    public static class WellKnownConfig
    implements Parcelable {
        @SerializedName(value="issuer")
        private String issuer;
        @SerializedName(value="network_authentication_target_ips")
        private Set<String> networkAuthenticationTargetIps;
        @SerializedName(value="network_authentication_target_urls")
        private Set<String> networkAuthenticationTargetUrls;
        public static final Parcelable.Creator<WellKnownConfig> CREATOR = new Parcelable.Creator<WellKnownConfig>(){

            public WellKnownConfig createFromParcel(Parcel in) {
                return new WellKnownConfig(in);
            }

            public WellKnownConfig[] newArray(int size) {
                return new WellKnownConfig[size];
            }
        };
        @SerializedName(value="telenordigital_sdk_analytics_endpoint")
        private String analyticsEndpoint;

        public String getIssuer() {
            return this.issuer;
        }

        public Set<String> getNetworkAuthenticationTargetIps() {
            return this.networkAuthenticationTargetIps != null ? this.networkAuthenticationTargetIps : Collections.emptySet();
        }

        public Set<String> getNetworkAuthenticationTargetUrls() {
            return this.networkAuthenticationTargetUrls != null ? this.networkAuthenticationTargetUrls : Collections.emptySet();
        }

        protected WellKnownConfig(Parcel in) {
            this.issuer = in.readString();
            int ipsCount = in.readInt();
            this.networkAuthenticationTargetIps = new HashSet<String>(ipsCount);
            for (int i = 0; i < ipsCount; ++i) {
                this.networkAuthenticationTargetIps.add(in.readString());
            }
            int urlsCount = in.readInt();
            this.networkAuthenticationTargetUrls = new HashSet<String>(urlsCount);
            for (int i = 0; i < urlsCount; ++i) {
                this.networkAuthenticationTargetUrls.add(in.readString());
            }
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.issuer);
            if (this.networkAuthenticationTargetIps == null) {
                dest.writeInt(0);
            } else {
                dest.writeInt(this.networkAuthenticationTargetIps.size());
                for (String ip : this.networkAuthenticationTargetIps) {
                    dest.writeString(ip);
                }
            }
            if (this.networkAuthenticationTargetUrls == null) {
                dest.writeInt(0);
            } else {
                dest.writeInt(this.networkAuthenticationTargetUrls.size());
                for (String url : this.networkAuthenticationTargetUrls) {
                    dest.writeString(url);
                }
            }
        }

        public String getAnalyticsEndpoint() {
            if (this.analyticsEndpoint != null) {
                try {
                    if ('/' != this.analyticsEndpoint.charAt(this.analyticsEndpoint.length() - 1)) {
                        return this.analyticsEndpoint + "/";
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
            return this.analyticsEndpoint;
        }
    }
}

