/*
 * Decompiled with CFR 0.152.
 */
package com.telenor.connect.ui;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.net.ConnectivityManager;
import android.net.Network;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.v4.app.DialogFragment;
import android.support.v7.app.AlertDialog;
import android.view.LayoutInflater;
import android.view.View;
import com.telenor.connect.R;
import com.telenor.connect.headerenrichment.HeLogic;

@RequiresApi(api=21)
public class TurnOnMobileDataDialogFragment
extends DialogFragment {
    private ConnectivityManager.NetworkCallback cellularNetworkCallback;
    private View automaticSignInButton;
    private ContinueListener listener;
    private View.OnClickListener automaticSignInButtonContinueCallback = new View.OnClickListener(){

        public void onClick(View v) {
            TurnOnMobileDataDialogFragment.this.automaticButtonPressed = true;
            TurnOnMobileDataDialogFragment.this.listener.onContinueClicked(TurnOnMobileDataDialogFragment.this);
        }
    };
    private View.OnClickListener regularSignInButtonContinueCallback = new View.OnClickListener(){

        public void onClick(View v) {
            TurnOnMobileDataDialogFragment.this.manualButtonPressed = true;
            TurnOnMobileDataDialogFragment.this.listener.onContinueClicked(TurnOnMobileDataDialogFragment.this);
        }
    };
    private boolean automaticButtonPressed = false;
    private boolean manualButtonPressed = false;

    @NonNull
    public Dialog onCreateDialog(@Nullable Bundle savedInstanceState) {
        LayoutInflater inflater = this.requireActivity().getLayoutInflater();
        View view = inflater.inflate(R.layout.com_telenor_connect_fragment_turn_on_mobile_data, null);
        this.automaticSignInButton = view.findViewById(R.id.com_telenor_connect_fragment_turn_on_mobile_data_sign_in_automatically_button);
        this.automaticSignInButton.setOnClickListener(this.automaticSignInButtonContinueCallback);
        view.findViewById(R.id.com_telenor_connect_fragment_turn_on_mobile_data_sign_in_regular_button).setOnClickListener(this.regularSignInButtonContinueCallback);
        return new AlertDialog.Builder((Context)this.getActivity()).setView(view).create();
    }

    public void onResume() {
        super.onResume();
        this.cellularNetworkCallback = new ConnectivityManager.NetworkCallback(){

            public void onAvailable(Network network) {
                this.enableButton(true);
            }

            private void enableButton(final boolean b) {
                TurnOnMobileDataDialogFragment.this.getActivity().runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        TurnOnMobileDataDialogFragment.this.automaticSignInButton.setEnabled(b);
                    }
                });
            }

            public void onUnavailable() {
                this.enableButton(false);
            }

            public void onLost(Network network) {
                this.enableButton(false);
            }
        };
        HeLogic.registerCellularNetworkCallback(this.cellularNetworkCallback);
    }

    public void onPause() {
        super.onPause();
        HeLogic.unRegisterCellularNetworkCallback(this.cellularNetworkCallback);
        this.dismiss();
    }

    public void setContinueListener(ContinueListener listener) {
        this.listener = listener;
    }

    public void onStop() {
        super.onStop();
        this.listener.onCancel(null);
    }

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        this.listener.onCancel(dialog);
    }

    public void onCancel(DialogInterface dialog) {
        super.onCancel(dialog);
        this.listener.onCancel(dialog);
    }

    public boolean isAtomaticButtonPressed() {
        return this.automaticButtonPressed;
    }

    public boolean isManualButtonPressed() {
        return this.manualButtonPressed;
    }

    public static interface ContinueListener {
        public void onContinueClicked(DialogFragment var1);

        public void onCancel(DialogInterface var1);
    }
}

