/*
 * Decompiled with CFR 0.152.
 */
package com.telenor.connect.headerenrichment;

import android.net.Network;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.WebResourceResponse;
import com.telenor.connect.ConnectSdk;
import com.telenor.connect.WellKnownAPI;
import com.telenor.connect.headerenrichment.HeLogic;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class MobileDataFetcher {
    private static final int MAX_REDIRECTS_TO_FOLLOW_FOR_HE = 5;

    @RequiresApi(api=21)
    public static String fetchUrlThroughCellular(String url) {
        boolean notSuccessStatus;
        WebResourceResponse webResourceResponse = MobileDataFetcher.fetchWebResourceResponse(url, false);
        if (webResourceResponse == null) {
            return null;
        }
        int statusCode = webResourceResponse.getStatusCode();
        boolean bl = notSuccessStatus = statusCode < 200 || statusCode >= 300;
        if (notSuccessStatus) {
            return null;
        }
        try {
            InputStream inputStream = webResourceResponse.getData();
            String response = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
            inputStream.close();
            return response;
        }
        catch (IOException e) {
            ConnectSdk.sendDebugErrorDataToAnalyticsEndpoint(e);
            return null;
        }
    }

    @RequiresApi(api=21)
    public static WebResourceResponse fetchWebResourceResponse(String originalUrl, boolean allowedToToggleNetworkToUse) {
        String newUrl = originalUrl;
        int attempts = 0;
        Network interfaceToUse = HeLogic.getCellularNetwork();
        if (interfaceToUse == null) {
            return null;
        }
        do {
            try {
                HttpURLConnection connection = (HttpURLConnection)interfaceToUse.openConnection(new URL(newUrl));
                connection.setInstanceFollowRedirects(false);
                connection.connect();
                int responseCode = connection.getResponseCode();
                ++attempts;
                if (responseCode != 303 && responseCode != 302 && responseCode != 301) {
                    return new WebResourceResponse(connection.getContentType(), connection.getContentEncoding(), connection.getResponseCode(), connection.getResponseMessage(), MobileDataFetcher.getHeadersAsCommaJoinedList(connection.getHeaderFields()), connection.getInputStream());
                }
                newUrl = connection.getHeaderField("Location");
                connection.getInputStream().close();
            }
            catch (IOException e) {
                Log.e((String)"ConnectSDK", (String)"Exception fetching resource", (Throwable)e);
                ConnectSdk.sendDebugErrorDataToAnalyticsEndpoint(e);
                return null;
            }
            if (!allowedToToggleNetworkToUse) continue;
            Network network = interfaceToUse = MobileDataFetcher.shouldFetchThroughCellular(newUrl) ? HeLogic.getCellularNetwork() : HeLogic.getDefaultNetwork();
        } while (attempts <= 5);
        return null;
    }

    private static Map<String, String> getHeadersAsCommaJoinedList(Map<String, List<String>> headerFields) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String header : headerFields.keySet()) {
            List<String> headerStringList = headerFields.get(header);
            if (headerStringList == null || headerStringList.isEmpty()) continue;
            String commaJoinedList = TextUtils.join((CharSequence)",", headerStringList);
            result.put(header, commaJoinedList);
        }
        return result;
    }

    public static boolean shouldFetchThroughCellular(String url) {
        String hostIp;
        WellKnownAPI.WellKnownConfig wellKnownConfig = ConnectSdk.getWellKnownConfig();
        if (wellKnownConfig == null || wellKnownConfig.getNetworkAuthenticationTargetIps().isEmpty() && wellKnownConfig.getNetworkAuthenticationTargetUrls().isEmpty()) {
            return false;
        }
        if (!wellKnownConfig.getNetworkAuthenticationTargetUrls().isEmpty()) {
            for (String urlPrefix : wellKnownConfig.getNetworkAuthenticationTargetUrls()) {
                if (!url.contains(urlPrefix)) continue;
                return true;
            }
            return false;
        }
        try {
            String host = new URL(url).getHost();
            hostIp = InetAddress.getByName(host).getHostAddress();
        }
        catch (MalformedURLException | UnknownHostException e) {
            ConnectSdk.sendDebugErrorDataToAnalyticsEndpoint(e);
            return false;
        }
        return wellKnownConfig.getNetworkAuthenticationTargetIps().contains(hostIp);
    }
}

