/*
 * Decompiled with CFR 0.152.
 */
package com.telenor.connect.ui;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Network;
import android.net.Uri;
import android.support.annotation.RequiresApi;
import android.view.View;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.telenor.connect.ConnectCallback;
import com.telenor.connect.ConnectSdk;
import com.telenor.connect.WellKnownAPI;
import com.telenor.connect.sms.SmsBroadcastReceiver;
import com.telenor.connect.sms.SmsHandler;
import com.telenor.connect.sms.SmsPinParseUtil;
import com.telenor.connect.sms.SmsRetrieverUtil;
import com.telenor.connect.ui.Instruction;
import com.telenor.connect.ui.InstructionHandler;
import com.telenor.connect.ui.WebErrorView;
import com.telenor.connect.utils.ConnectUtils;
import com.telenor.connect.utils.JavascriptUtil;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.List;
import java.util.regex.Pattern;

public class ConnectWebViewClient
extends WebViewClient
implements SmsHandler,
InstructionHandler {
    private static final int DELAY_HIDE_NATIVE_LOADING_VIEW = 50;
    private static final Pattern TD_HTTPS_PATTERN = Pattern.compile("^https://.*telenordigital.com(?:$|/)");
    private static final String JAVASCRIPT_PROCESSES_INSTRUCTIONS = "javascript:if (document.getElementById('android-instructions') !== null) {window.AndroidInterface.processInstructions(document.getElementById('android-instructions').innerHTML)}";
    private final Activity activity;
    private final View loadingView;
    private final WebErrorView errorView;
    private final WebView webView;
    private final ConnectCallback connectCallback;
    private boolean waitingForPinSms = false;
    private boolean instructionsReceived;
    private Instruction callbackInstruction;
    private String savedSmsBody;

    public ConnectWebViewClient(Activity activity, WebView webView, View loadingView, WebErrorView errorView, ConnectCallback callback) {
        this.webView = webView;
        this.activity = activity;
        this.loadingView = loadingView;
        this.errorView = errorView;
        this.connectCallback = callback;
        SmsRetrieverUtil.startSmsRetriever((Context)activity);
        SmsBroadcastReceiver smsBroadcastReceiver = new SmsBroadcastReceiver(this);
        activity.registerReceiver((BroadcastReceiver)smsBroadcastReceiver, SmsRetrieverUtil.SMS_FILTER);
    }

    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        if (ConnectSdk.getRedirectUri() != null && url.startsWith(ConnectSdk.getRedirectUri())) {
            ConnectUtils.parseAuthCode(url, this.getOriginalState(), this.connectCallback);
            return true;
        }
        return false;
    }

    private String getOriginalState() {
        String url = this.activity.getIntent().getStringExtra("com.telenor.connect.LOGIN_AUTH_URI");
        return Uri.parse((String)url).getQueryParameter("state");
    }

    @TargetApi(value=21)
    public WebResourceResponse shouldInterceptRequest(WebView view, WebResourceRequest request) {
        if (!ConnectSdk.isCellularDataNetworkConnected() || ConnectSdk.isCellularDataNetworkDefault()) {
            return null;
        }
        if (this.shouldFetchThroughCellular(request.getUrl().toString())) {
            return this.fetchUrlTroughCellular(request.getUrl().toString());
        }
        return null;
    }

    public boolean shouldFetchThroughCellular(String url) {
        String hostIp;
        WellKnownAPI.WellKnownConfig wellKnownConfig = (WellKnownAPI.WellKnownConfig)this.activity.getIntent().getExtras().get("com.telenor.connect.WELL_KNOWN_CONFIG");
        if (wellKnownConfig == null || wellKnownConfig.getNetworkAuthenticationTargetIps().isEmpty() && wellKnownConfig.getNetworkAuthenticationTargetUrls().isEmpty()) {
            return false;
        }
        if (!wellKnownConfig.getNetworkAuthenticationTargetUrls().isEmpty()) {
            for (String urlPrefix : wellKnownConfig.getNetworkAuthenticationTargetUrls()) {
                if (!url.contains(urlPrefix)) continue;
                return true;
            }
            return false;
        }
        try {
            String host = new URL(url).getHost();
            hostIp = InetAddress.getByName(host).getHostAddress();
        }
        catch (MalformedURLException | UnknownHostException e) {
            return false;
        }
        return wellKnownConfig.getNetworkAuthenticationTargetIps().contains(hostIp);
    }

    @TargetApi(value=21)
    public WebResourceResponse fetchUrlTroughCellular(String originalUrl) {
        String newUrl = originalUrl;
        int attempts = 0;
        Network interfaceToUse = ConnectSdk.getCellularNetwork();
        do {
            try {
                HttpURLConnection connection = (HttpURLConnection)interfaceToUse.openConnection(new URL(newUrl));
                connection.setInstanceFollowRedirects(false);
                connection.connect();
                int responseCode = connection.getResponseCode();
                ++attempts;
                if (responseCode != 303 && responseCode != 302 && responseCode != 301) {
                    return new WebResourceResponse(connection.getContentType(), connection.getContentEncoding(), connection.getInputStream());
                }
                newUrl = connection.getHeaderField("Location");
                connection.getInputStream().close();
            }
            catch (IOException e) {
                return null;
            }
            Network network = interfaceToUse = this.shouldFetchThroughCellular(newUrl) ? ConnectSdk.getCellularNetwork() : ConnectSdk.getDefaultNetwork();
        } while (attempts <= 5);
        return null;
    }

    @RequiresApi(api=23)
    public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
        super.onReceivedError(view, request, error);
        String errorText = error.getDescription() + " (" + error.getErrorCode() + ")";
        this.errorView.setErrorText(errorText, request.getUrl().toString());
        this.errorView.setVisibility(0);
    }

    public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        super.onReceivedError(view, errorCode, description, failingUrl);
        String errorText = description + " (" + errorCode + ")";
        this.errorView.setErrorText(errorText, failingUrl);
        this.errorView.setVisibility(0);
    }

    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        this.hideLoadingViewWithDelayIfHEILoading(url);
        this.instructionsReceived = false;
        super.onPageStarted(view, url, favicon);
    }

    private void hideLoadingViewWithDelayIfHEILoading(String url) {
        if (url != null && url.endsWith("/heidetect") && this.loadingView.getVisibility() == 0) {
            this.loadingView.postDelayed(new Runnable(){

                @Override
                public void run() {
                    ConnectWebViewClient.this.loadingView.setVisibility(8);
                }
            }, 50L);
        }
    }

    public void onPageFinished(WebView view, String url) {
        super.onPageFinished(view, url);
        this.loadingView.setVisibility(8);
        if (!this.instructionsReceived && this.shouldCheckPageForInstructions(url)) {
            this.webView.loadUrl(JAVASCRIPT_PROCESSES_INSTRUCTIONS);
        }
    }

    private boolean shouldCheckPageForInstructions(String url) {
        return TD_HTTPS_PATTERN.matcher(url).find();
    }

    @Override
    public void givenInstructions(List<Instruction> instructions) {
        if (this.instructionsReceived) {
            return;
        }
        this.instructionsReceived = true;
        if (this.containsSmsInstruction(instructions)) {
            this.executeInstructions(instructions);
        }
    }

    private boolean containsSmsInstruction(List<Instruction> instructions) {
        for (Instruction instruction : instructions) {
            if (!instruction.getName().equals("androidSystemCall_getPinFromSms")) continue;
            return true;
        }
        return false;
    }

    private void executeInstructions(List<Instruction> instructions) {
        for (Instruction instruction : instructions) {
            if (instruction.getName().equals("androidSystemCall_getPinFromSms")) {
                this.getPinFromSms(instruction);
                continue;
            }
            this.runJavascriptInstruction(instruction);
        }
    }

    private void runJavascriptInstruction(final Instruction instruction) {
        this.webView.post(new Runnable(){

            @Override
            public void run() {
                String javascript = JavascriptUtil.getJavascriptString(instruction);
                ConnectWebViewClient.this.webView.loadUrl("javascript:" + javascript);
            }
        });
    }

    private void getPinFromSms(Instruction instruction) {
        this.callbackInstruction = instruction;
        this.waitingForPinSms = true;
        this.handleIfSmsAlreadyArrived();
    }

    private void stopWaitingForPin() {
        this.waitingForPinSms = false;
        this.savedSmsBody = null;
        this.callbackInstruction = null;
    }

    private void handleIfSmsAlreadyArrived() {
        if (this.savedSmsBody == null) {
            return;
        }
        this.webView.post(new Runnable(){

            @Override
            public void run() {
                ConnectWebViewClient.this.receivedSms(ConnectWebViewClient.this.savedSmsBody);
            }
        });
    }

    private synchronized void handlePinFromSmsBodyIfPresent(String body, final Instruction instruction) {
        final String foundPin = SmsPinParseUtil.findPin(body, instruction);
        if (this.waitingForPinSms && foundPin != null && instruction.getPinCallbackName() != null) {
            this.stopWaitingForPin();
            this.webView.post(new Runnable(){

                @Override
                public void run() {
                    String javascript = JavascriptUtil.getJavascriptString(instruction.getPinCallbackName(), "'" + foundPin + "'");
                    ConnectWebViewClient.this.webView.loadUrl("javascript:" + javascript);
                }
            });
        }
    }

    @Override
    public void receivedSms(String messageBody) {
        if (this.callbackInstruction == null) {
            this.savedSmsBody = messageBody;
            return;
        }
        this.handlePinFromSmsBodyIfPresent(messageBody, this.callbackInstruction);
    }
}

