/*
 * Decompiled with CFR 0.152.
 */
package com.telenor.connect;

import android.os.Build;
import com.google.gson.annotations.SerializedName;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;

public interface AnalyticsAPI {
    @Headers(value={"Content-Type: application/json"})
    @POST(value="V1/android")
    public Call<Void> sendAnalyticsData(@Header(value="Authorization") String var1, @Body SDKAnalyticsData var2);

    public static class SDKAnalyticsData {
        @SerializedName(value="appName")
        private final String appName;
        @SerializedName(value="appVersion")
        private final String appVersion;
        @SerializedName(value="subject")
        private final String subject;
        @SerializedName(value="log_session_id")
        private final String logSessionId;
        @SerializedName(value="advertisingId")
        private final String advertisingId;
        @SerializedName(value="tsSdkInitiliazation")
        private final long tsSdkInitiliazation;
        @SerializedName(value="tsLoginButtonClicked")
        private final long tsLoginButtonClicked;
        @SerializedName(value="tsRedirectUrlInvoked")
        private final long tsRedirectUrlInvoked;
        @SerializedName(value="tsTokenResponseReceived")
        private final long tsTokenResponseReceived;
        @SerializedName(value="deviceManufacturer")
        private final String deviceManufacturer;
        @SerializedName(value="deviceModel")
        private final String deviceModel;
        @SerializedName(value="osName")
        private final String osName;
        @SerializedName(value="osVersion")
        private final String osVersion;
        @SerializedName(value="os_sdk_version")
        private final int osSdkVersion;

        public SDKAnalyticsData(String appName, String appVersion, String subject, String logSessionId, String advertisingId, long tsSdkInitiliazation, long tsLoginButtonClicked, long tsRedirectUrlInvoked, long tsTokenResponseReceived) {
            this.appName = appName;
            this.appVersion = appVersion;
            this.subject = subject;
            this.logSessionId = logSessionId;
            this.advertisingId = advertisingId;
            this.tsSdkInitiliazation = tsSdkInitiliazation;
            this.tsLoginButtonClicked = tsLoginButtonClicked;
            this.tsRedirectUrlInvoked = tsRedirectUrlInvoked;
            this.tsTokenResponseReceived = tsTokenResponseReceived;
            this.deviceManufacturer = Build.MANUFACTURER;
            this.deviceModel = Build.MODEL;
            this.osName = System.getProperty("os.name");
            this.osVersion = System.getProperty("os.version");
            this.osSdkVersion = Build.VERSION.SDK_INT;
        }
    }
}

