/*
 * Decompiled with CFR 0.152.
 */
package com.telenor.connect.id;

import android.util.Log;
import com.telenor.connect.ConnectCallback;
import com.telenor.connect.ConnectSdk;
import com.telenor.connect.utils.Validator;
import java.util.Map;

public class ParseTokenCallback
implements ConnectCallback {
    private final ConnectCallback callback;

    public ParseTokenCallback(ConnectCallback callback) {
        this.callback = callback;
    }

    @Override
    public void onSuccess(Object successData) {
        Validator.notNullOrEmpty(successData.toString(), "auth reponse");
        Map authCodeData = (Map)successData;
        if (ConnectSdk.isConfidentialClient()) {
            this.callback.onSuccess(successData);
        } else {
            ConnectSdk.getAccessTokenFromCode((String)authCodeData.get("code"), this.callback);
        }
    }

    @Override
    public void onError(Object errorData) {
        Log.e((String)"ConnectSDK", (String)errorData.toString());
        this.callback.onError(errorData);
    }
}

