/*
 * Decompiled with CFR 0.152.
 */
package com.telenor.connect.ui;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.customtabs.CustomTabsCallback;
import android.support.customtabs.CustomTabsClient;
import android.support.customtabs.CustomTabsIntent;
import android.support.customtabs.CustomTabsServiceConnection;
import android.support.customtabs.CustomTabsSession;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import com.telenor.connect.BrowserType;
import com.telenor.connect.ConnectSdk;
import com.telenor.connect.R;
import com.telenor.connect.ui.ConnectWebViewLoginButton;
import com.telenor.connect.utils.ConnectUrlHelper;
import com.telenor.connect.utils.CustomTabsHelper;
import com.telenor.connect.utils.Validator;
import java.lang.ref.WeakReference;
import java.util.Map;

public class ConnectLoginButton
extends ConnectWebViewLoginButton {
    private static final Uri PRE_FETCH_URL = Uri.parse((String)ConnectUrlHelper.getConnectApiUrl().newBuilder().addPathSegment("id").addPathSegment("android-sdk-prefetch-static-resources").build().uri().toString());
    private View.OnClickListener onClickListener;
    private CustomTabsServiceConnection connection;
    private boolean customTabsSupported = false;
    private boolean launchCustomTabInNewTask = true;
    private boolean serviceBound = false;
    private BrowserType browserType;
    private CustomTabsSession session;

    public ConnectLoginButton(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.setText(R.string.com_telenor_connect_login_button_text);
        this.onClickListener = new LoginClickListener();
        this.setOnClickListener(this.onClickListener);
    }

    public void setLaunchCustomTabInNewTask(boolean launchCustomTabInNewTask) {
        this.launchCustomTabInNewTask = launchCustomTabInNewTask;
    }

    public View.OnClickListener getOnClickListener() {
        return this.onClickListener;
    }

    private Uri getAuthorizeUri() {
        Map<String, String> parameters = this.getParameters();
        return ConnectUrlHelper.getAuthorizeUri(parameters, this.browserType);
    }

    private static boolean contextIntentFilterMatchesRedirectUri(Context context) {
        PackageManager manager;
        Uri parse = Uri.parse((String)ConnectSdk.getRedirectUri());
        Intent intent = new Intent().setData(parse);
        ComponentName componentName = intent.resolveActivity(manager = context.getPackageManager());
        if (componentName == null) {
            return false;
        }
        return context.getPackageName().equals(componentName.getPackageName());
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        String packageNameToUse = CustomTabsHelper.getPackageNameToUse(this.getContext());
        if (TextUtils.isEmpty((CharSequence)packageNameToUse)) {
            return;
        }
        this.connection = new WeakReferenceCustomTabsServiceConnection(new WeakReference<ConnectLoginButton>(this));
        this.serviceBound = CustomTabsClient.bindCustomTabsService((Context)this.getContext(), (String)packageNameToUse, (CustomTabsServiceConnection)this.connection);
        boolean correctIntentFilter = ConnectLoginButton.contextIntentFilterMatchesRedirectUri(this.getContext());
        this.customTabsSupported = this.serviceBound && correctIntentFilter;
        this.browserType = this.customTabsSupported ? BrowserType.CHROME_CUSTOM_TAB : BrowserType.WEB_VIEW;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.serviceBound) {
            this.getContext().unbindService((ServiceConnection)this.connection);
            this.serviceBound = false;
        }
        if (this.connection != null) {
            this.connection = null;
        }
    }

    private void launchWebViewAuthentication() {
        this.startWebViewAuthentication();
    }

    private void launchChromeCustomTabAuthentication() {
        CustomTabsIntent.Builder builder = new CustomTabsIntent.Builder(this.session);
        CustomTabsIntent cctIntent = builder.build();
        Intent intent = cctIntent.intent;
        if (this.launchCustomTabInNewTask) {
            intent.setFlags(0x10000000);
        }
        if (Build.VERSION.SDK_INT >= 22) {
            intent.putExtra("android.intent.extra.REFERRER", (Parcelable)Uri.parse((String)("2//" + this.getContext().getPackageName())));
        }
        Uri authorizeUri = this.getAuthorizeUri();
        cctIntent.launchUrl((Context)this.getActivity(), authorizeUri);
    }

    private void setSession(CustomTabsSession session) {
        this.session = session;
    }

    private static class WeakReferenceCustomTabsCallback
    extends CustomTabsCallback {
        private final WeakReference<ConnectLoginButton> weakButton;

        WeakReferenceCustomTabsCallback(WeakReference<ConnectLoginButton> weakButton) {
            this.weakButton = weakButton;
        }

        public void onNavigationEvent(int navigationEvent, Bundle extras) {
            ConnectLoginButton connectLoginButton = (ConnectLoginButton)((Object)this.weakButton.get());
            if (connectLoginButton == null) {
                return;
            }
            switch (navigationEvent) {
                case 6: {
                    connectLoginButton.setEnabled(true);
                    return;
                }
                case 5: {
                    connectLoginButton.setEnabled(false);
                    return;
                }
            }
        }
    }

    private static class WeakReferenceCustomTabsServiceConnection
    extends CustomTabsServiceConnection {
        private final WeakReference<ConnectLoginButton> weakButton;

        WeakReferenceCustomTabsServiceConnection(WeakReference<ConnectLoginButton> weakButton) {
            this.weakButton = weakButton;
        }

        public void onCustomTabsServiceConnected(ComponentName name, CustomTabsClient client) {
            ConnectLoginButton connectLoginButton = (ConnectLoginButton)((Object)this.weakButton.get());
            if (connectLoginButton == null) {
                return;
            }
            client.warmup(0L);
            CustomTabsSession session = client.newSession((CustomTabsCallback)new WeakReferenceCustomTabsCallback(this.weakButton));
            connectLoginButton.setSession(session);
            if (session != null) {
                session.mayLaunchUrl(PRE_FETCH_URL, null, null);
            }
        }

        public void onServiceDisconnected(ComponentName name) {
        }
    }

    private class LoginClickListener
    implements View.OnClickListener {
        private LoginClickListener() {
        }

        public void onClick(View v) {
            Validator.sdkInitialized();
            ConnectSdk.beforeAuthentication();
            if (!ConnectLoginButton.this.customTabsSupported) {
                ConnectLoginButton.this.launchWebViewAuthentication();
            } else {
                ConnectLoginButton.this.launchChromeCustomTabAuthentication();
            }
        }
    }
}

