/*
 * Decompiled with CFR 0.152.
 */
package com.telenor.connect;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.GoogleApiAvailability;
import com.telenor.connect.AnalyticsAPI;
import com.telenor.connect.BrowserType;
import com.telenor.connect.ConnectCallback;
import com.telenor.connect.ConnectException;
import com.telenor.connect.WellKnownAPI;
import com.telenor.connect.WellKnownConfigStore;
import com.telenor.connect.id.AccessTokenCallback;
import com.telenor.connect.id.ConnectIdService;
import com.telenor.connect.id.ConnectStore;
import com.telenor.connect.id.IdToken;
import com.telenor.connect.id.UserInfo;
import com.telenor.connect.ui.ConnectActivity;
import com.telenor.connect.ui.ConnectWebFragment;
import com.telenor.connect.utils.ConnectUrlHelper;
import com.telenor.connect.utils.RestHelper;
import com.telenor.connect.utils.Validator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import retrofit.Callback;
import retrofit.ResponseCallback;
import retrofit.RetrofitError;
import retrofit.client.Response;

public final class ConnectSdk {
    private static ArrayList<Locale> sLocales;
    private static ConnectivityManager connectivityManager;
    private static volatile Network cellularNetwork;
    private static volatile Network defaultNetwork;
    private static ConnectStore connectStore;
    private static WellKnownConfigStore lastSeenWellKnownConfigStore;
    private static ConnectIdService connectIdService;
    private static Context context;
    private static boolean confidentialClient;
    private static WellKnownAPI.WellKnownConfig wellKnownConfig;
    private static volatile boolean isInitialized;
    private static String clientId;
    private static String redirectUri;
    private static boolean useStaging;
    private static volatile String advertisingId;
    private static volatile long tsSdkInitiliazation;
    private static volatile long tsLoginButtonClicked;
    private static volatile long tsRedirectUrlInvoked;
    private static volatile long tsTokenResponseReceived;
    private static volatile String logSessionId;
    public static final String CLIENT_ID_PROPERTY = "com.telenor.connect.CLIENT_ID";
    public static final String CONFIDENTIAL_CLIENT_PROPERTY = "com.telenor.connect.CONFIDENTIAL_CLIENT";
    public static final String REDIRECT_URI_PROPERTY = "com.telenor.connect.REDIRECT_URI";
    public static final String ACTION_LOGIN_STATE_CHANGED = "com.telenor.connect.ACTION_LOGIN_STATE_CHANGED";
    public static final String EXTRA_CONNECT_TOKENS = "com.telenor.connect.EXTRA_CONNECT_TOKENS";
    public static final int MAX_REDIRECTS_TO_FOLLOW_FOR_HE = 5;

    public static void beforeAuthentication() {
        logSessionId = UUID.randomUUID().toString();
        tsLoginButtonClicked = System.currentTimeMillis();
    }

    public static synchronized void authenticate(Activity activity, int requestCode, String ... scopeTokens) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("scope", TextUtils.join((CharSequence)" ", (Object[])scopeTokens));
        ConnectSdk.authenticate(activity, parameters, requestCode);
    }

    public static synchronized void authenticate(Activity activity, Map<String, String> parameters, int requestCode) {
        Validator.sdkInitialized();
        ConnectSdk.authenticate(activity, parameters, -1, requestCode);
    }

    public static synchronized void authenticate(Activity activity, Map<String, String> parameters, int customLoadingLayout, int requestCode) {
        Validator.sdkInitialized();
        Intent intent = ConnectSdk.getAuthIntent(parameters);
        if (customLoadingLayout != -1) {
            intent.putExtra("com.telenor.connect.CUSTOM_LOADING_SCREEN_EXTRA", customLoadingLayout);
        }
        activity.startActivityForResult(intent, requestCode);
    }

    private static Intent getAuthIntent(Map<String, String> parameters) {
        Intent intent = new Intent();
        intent.setClass(ConnectSdk.getContext(), ConnectActivity.class);
        intent.setAction("com.telenor.connect.LOGIN_ACTION");
        String mccMnc = ConnectSdk.getMccMnc();
        if (!(TextUtils.isEmpty((CharSequence)mccMnc) || wellKnownConfig == null || wellKnownConfig.getNetworkAuthenticationTargetIps().isEmpty() && wellKnownConfig.getNetworkAuthenticationTargetUrls().isEmpty())) {
            parameters.put("login_hint", String.format("MCCMNC:%s", mccMnc));
        }
        String url = ConnectUrlHelper.getAuthorizeUri(parameters, BrowserType.WEB_VIEW).toString();
        intent.putExtra("com.telenor.connect.LOGIN_AUTH_URI", url);
        intent.putExtra("com.telenor.connect.WELL_KNOWN_CONFIG", (Parcelable)wellKnownConfig);
        return intent;
    }

    public static Fragment getAuthFragment(Map<String, String> parameters) {
        Validator.sdkInitialized();
        ConnectWebFragment fragment = new ConnectWebFragment();
        Intent authIntent = ConnectSdk.getAuthIntent(parameters);
        String action = authIntent.getAction();
        Bundle bundle = new Bundle(authIntent.getExtras());
        bundle.putString("com.telenor.connect.ACTION_ARGUMENT", action);
        fragment.setArguments(bundle);
        fragment.setRetainInstance(true);
        return fragment;
    }

    public static synchronized void getValidAccessToken(AccessTokenCallback callback) {
        Validator.sdkInitialized();
        if (connectIdService != null) {
            connectIdService.getValidAccessToken(callback);
        }
    }

    public static synchronized String getAccessToken() {
        Validator.sdkInitialized();
        if (connectIdService != null) {
            return connectIdService.getAccessToken();
        }
        return null;
    }

    public static synchronized Date getAccessTokenExpirationTime() {
        Validator.sdkInitialized();
        return connectIdService.getAccessTokenExpirationTime();
    }

    public static synchronized void getAccessTokenFromCode(String code, final ConnectCallback callback) {
        Validator.sdkInitialized();
        tsRedirectUrlInvoked = System.currentTimeMillis();
        connectIdService.getAccessTokenFromCode(code, new ConnectCallback(){

            @Override
            public void onSuccess(Object successData) {
                tsTokenResponseReceived = System.currentTimeMillis();
                if (callback != null) {
                    callback.onSuccess(successData);
                }
                ConnectSdk.sendAnalyticsData();
            }

            @Override
            public void onError(Object errorData) {
                tsTokenResponseReceived = System.currentTimeMillis();
                if (callback != null) {
                    callback.onError(errorData);
                }
                ConnectSdk.sendAnalyticsData();
            }
        });
    }

    private static void sendAnalyticsData() {
        if (ConnectSdk.getWellKnownConfig() == null || ConnectSdk.getWellKnownConfig().getAnalyticsEndpoint() == null) {
            return;
        }
        String accessToken = ConnectSdk.getAccessToken();
        String auth = accessToken != null ? "Bearer " + accessToken : null;
        String subject = ConnectSdk.getIdToken() != null ? ConnectSdk.getIdToken().getSubject() : null;
        RestHelper.getAnalyticsApi(ConnectSdk.getWellKnownConfig().getAnalyticsEndpoint()).sendAnalyticsData(auth, new AnalyticsAPI.SDKAnalyticsData(ConnectSdk.getApplicationName(), ConnectSdk.getApplicationVersion(), subject, ConnectSdk.getLogSessionId(), ConnectSdk.getAdvertisingId(), tsSdkInitiliazation, tsLoginButtonClicked, tsRedirectUrlInvoked, tsTokenResponseReceived), new ResponseCallback(){

            public void success(Response response) {
            }

            public void failure(RetrofitError error) {
                Log.e((String)"ConnectSDK", (String)"Failed to send analytics data", (Throwable)error);
            }
        });
    }

    public static Context getContext() {
        Validator.sdkInitialized();
        return context;
    }

    public static String getClientId() {
        Validator.sdkInitialized();
        return clientId;
    }

    public static ArrayList<Locale> getLocales() {
        Validator.sdkInitialized();
        return sLocales;
    }

    public static String getRedirectUri() {
        Validator.sdkInitialized();
        return redirectUri;
    }

    public static ArrayList<String> getUiLocales() {
        ArrayList<String> locales = new ArrayList<String>();
        if (ConnectSdk.getLocales() != null && !ConnectSdk.getLocales().isEmpty()) {
            for (Locale locale : ConnectSdk.getLocales()) {
                locales.add(locale.toString());
                locales.add(locale.getLanguage());
            }
        }
        locales.add(Locale.getDefault().toString());
        locales.add(Locale.getDefault().getLanguage());
        return locales;
    }

    public static String getExpectedIssuer() {
        Validator.sdkInitialized();
        if (ConnectSdk.getWellKnownConfig() != null) {
            return ConnectSdk.getWellKnownConfig().getIssuer();
        }
        return ConnectUrlHelper.getConnectApiUrl() + "oauth";
    }

    public static List<String> getExpectedAudiences() {
        Validator.sdkInitialized();
        return Collections.singletonList(clientId);
    }

    public static synchronized boolean isConfidentialClient() {
        Validator.sdkInitialized();
        return confidentialClient;
    }

    public static synchronized boolean isInitialized() {
        return isInitialized;
    }

    public static void logout() {
        Validator.sdkInitialized();
        connectIdService.logOut(ConnectSdk.getContext());
    }

    public static synchronized void sdkInitialize(Context applicationContext) {
        ConnectSdk.sdkInitialize(applicationContext, true);
    }

    public static synchronized void sdkInitialize(Context applicationContext, boolean useStagingEnvironment) {
        if (ConnectSdk.isInitialized()) {
            return;
        }
        context = applicationContext;
        Validator.notNull(context, "context");
        useStaging = useStagingEnvironment;
        ConnectSdk.loadConnectConfig(context);
        connectStore = new ConnectStore(context);
        lastSeenWellKnownConfigStore = new WellKnownConfigStore(context);
        wellKnownConfig = lastSeenWellKnownConfigStore.get();
        isInitialized = true;
        connectIdService = new ConnectIdService(connectStore, RestHelper.getConnectApi(ConnectUrlHelper.getConnectApiUrl().toString()), clientId, redirectUri);
        RestHelper.getWellKnownApi(ConnectUrlHelper.getWellKnownEndpoint()).getWellKnownConfig(new Callback<WellKnownAPI.WellKnownConfig>(){

            public void success(WellKnownAPI.WellKnownConfig config, Response response) {
                wellKnownConfig = config;
                lastSeenWellKnownConfigStore.set(config);
            }

            public void failure(RetrofitError error) {
                wellKnownConfig = null;
            }
        });
        connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivityManager != null && Build.VERSION.SDK_INT >= 21) {
            ConnectSdk.initalizeCellularNetwork();
            ConnectSdk.initalizeDefaultNetwork();
        }
        tsSdkInitiliazation = System.currentTimeMillis();
        ConnectSdk.initializeAdvertisingId();
    }

    public static String getMccMnc() {
        TelephonyManager tel = (TelephonyManager)ConnectSdk.getContext().getSystemService("phone");
        return tel.getNetworkOperator();
    }

    public static void setLocales(Locale ... locales) {
        sLocales = new ArrayList<Locale>(Arrays.asList(locales));
    }

    public static void setLocales(ArrayList<Locale> locales) {
        sLocales = locales;
    }

    public static void updateTokens(AccessTokenCallback callback) {
        Validator.sdkInitialized();
        connectIdService.updateTokens(callback);
    }

    private static void loadConnectConfig(Context context) {
        Object redirectUriObject;
        ApplicationInfo ai = ConnectSdk.getApplicationInfo(context);
        if (ai == null || ai.metaData == null) {
            throw new ConnectException("No application metadata was found.");
        }
        confidentialClient = ConnectSdk.fetchBooleanProperty(ai, CONFIDENTIAL_CLIENT_PROPERTY);
        Object clientIdObject = ai.metaData.get(CLIENT_ID_PROPERTY);
        if (clientIdObject instanceof String) {
            clientId = (String)clientIdObject;
        }
        if ((redirectUriObject = ai.metaData.get(REDIRECT_URI_PROPERTY)) instanceof String) {
            redirectUri = (String)redirectUriObject;
        }
    }

    private static ApplicationInfo getApplicationInfo(Context context) {
        try {
            return context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
    }

    private static boolean fetchBooleanProperty(ApplicationInfo appInfo, String propertyName) {
        if (appInfo == null) {
            return false;
        }
        if (appInfo.metaData == null) {
            return false;
        }
        Object booleanPropertyObject = appInfo.metaData.get(propertyName);
        if (!(booleanPropertyObject instanceof Boolean)) {
            return false;
        }
        return (Boolean)booleanPropertyObject;
    }

    public static WellKnownAPI.WellKnownConfig getWellKnownConfig() {
        Validator.sdkInitialized();
        return wellKnownConfig;
    }

    @Deprecated
    public static String getSubjectId() {
        Validator.sdkInitialized();
        IdToken idToken = connectIdService.getIdToken();
        return idToken != null ? idToken.getSubject() : null;
    }

    public static IdToken getIdToken() {
        Validator.sdkInitialized();
        return connectIdService.getIdToken();
    }

    public static void getUserInfo(Callback<UserInfo> userInfoCallback) {
        Validator.sdkInitialized();
        connectIdService.getUserInfo(userInfoCallback);
    }

    public static boolean hasValidRedirectUrlCall(Intent intent) {
        Uri data = intent.getData();
        if (data == null) {
            return false;
        }
        boolean startsWithCorrect = data.toString().startsWith(ConnectSdk.getRedirectUri());
        if (!startsWithCorrect) {
            return false;
        }
        String state = data.getQueryParameter("state");
        String originalState = connectStore.getSessionStateParam();
        if (originalState != null && !originalState.equals(state)) {
            return false;
        }
        String code = data.getQueryParameter("code");
        return code != null && !code.isEmpty();
    }

    public static void handleRedirectUriCallIfPresent(Intent intent, ConnectCallback callback) {
        if (!ConnectSdk.hasValidRedirectUrlCall(intent)) {
            return;
        }
        String code = ConnectSdk.getCodeFromIntent(intent);
        ConnectSdk.getAccessTokenFromCode(code, callback);
    }

    public static String getCodeFromIntent(@NonNull Intent intent) {
        Uri data = intent.getData();
        return data.getQueryParameter("code");
    }

    public static boolean isCellularDataNetworkConnected() {
        if (connectivityManager == null) {
            return false;
        }
        NetworkInfo networkInfo = null;
        if (Build.VERSION.SDK_INT < 21) {
            networkInfo = connectivityManager.getNetworkInfo(0);
        } else {
            if (cellularNetwork == null) {
                return false;
            }
            networkInfo = connectivityManager.getNetworkInfo(cellularNetwork);
        }
        return networkInfo != null && networkInfo.isConnected();
    }

    public static boolean isCellularDataNetworkDefault() {
        if (connectivityManager == null) {
            return false;
        }
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.getType() == 0;
    }

    @TargetApi(value=21)
    private static void initalizeCellularNetwork() {
        NetworkRequest networkRequest = new NetworkRequest.Builder().addCapability(12).addTransportType(0).build();
        try {
            connectivityManager.requestNetwork(networkRequest, new ConnectivityManager.NetworkCallback(){

                public void onAvailable(Network network) {
                    cellularNetwork = network;
                }
            });
        }
        catch (SecurityException e) {
            cellularNetwork = null;
        }
    }

    @TargetApi(value=21)
    private static void initalizeDefaultNetwork() {
        NetworkRequest networkRequest = new NetworkRequest.Builder().addCapability(12).build();
        try {
            connectivityManager.requestNetwork(networkRequest, new ConnectivityManager.NetworkCallback(){

                public void onAvailable(Network network) {
                    defaultNetwork = network;
                }
            });
        }
        catch (SecurityException e) {
            defaultNetwork = null;
        }
    }

    private static void initializeAdvertisingId() {
        GoogleApiAvailability googleAPI = GoogleApiAvailability.getInstance();
        if (googleAPI.isGooglePlayServicesAvailable(ConnectSdk.getContext()) == 0) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    AdvertisingIdClient.Info adInfo = null;
                    try {
                        adInfo = AdvertisingIdClient.getAdvertisingIdInfo((Context)ConnectSdk.getContext());
                        advertisingId = adInfo.getId();
                    }
                    catch (Exception e) {
                        Log.w((String)"ConnectSDK", (String)"Failed to read advertising id", (Throwable)e);
                    }
                }
            }).start();
        }
    }

    @TargetApi(value=21)
    public static Network getCellularNetwork() {
        return cellularNetwork;
    }

    @TargetApi(value=21)
    public static Network getDefaultNetwork() {
        return defaultNetwork;
    }

    private static String getAdvertisingId() {
        return advertisingId;
    }

    public static String getLogSessionId() {
        return logSessionId;
    }

    private static String getApplicationName() {
        try {
            return ConnectSdk.getContext().getApplicationInfo().loadLabel(ConnectSdk.getContext().getPackageManager()).toString();
        }
        catch (Exception e) {
            Log.e((String)"ConnectSDK", (String)"Failed to read application name", (Throwable)e);
            return "";
        }
    }

    private static String getApplicationVersion() {
        try {
            return ConnectSdk.getContext().getPackageManager().getPackageInfo((String)ConnectSdk.getContext().getPackageName(), (int)0).versionName;
        }
        catch (Exception e) {
            Log.e((String)"ConnectSDK", (String)"Failed to read application version", (Throwable)e);
            return "";
        }
    }

    public static boolean useStaging() {
        Validator.sdkInitialized();
        return useStaging;
    }

    public static ConnectStore getConnectStore() {
        Validator.sdkInitialized();
        return connectStore;
    }

    static {
        isInitialized = false;
    }
}

