/*
 * Decompiled with CFR 0.152.
 */
package com.telenor.connect.ui;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import com.telenor.connect.ConnectException;
import com.telenor.connect.ConnectSdk;
import com.telenor.connect.R;
import com.telenor.connect.id.Claims;
import com.telenor.connect.id.ConnectStore;
import com.telenor.connect.ui.ConnectButton;
import com.telenor.connect.utils.ClaimsParameterFormatter;
import com.telenor.connect.utils.Validator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;

public class ConnectWebViewLoginButton
extends ConnectButton {
    public static final int NO_CUSTOM_LAYOUT = -1;
    private ArrayList<String> acrValues;
    private Map<String, String> loginParameters;
    private ArrayList<String> loginScopeTokens;
    private int requestCode = 43399;
    private Claims claims;
    private int customLoadingLayout = -1;
    private ConnectStore connectStore;

    public ConnectWebViewLoginButton(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.setText(R.string.com_telenor_connect_login_button_text);
        this.setOnClickListener(new LoginClickListener());
        this.connectStore = new ConnectStore(context);
    }

    public ArrayList<String> getAcrValues() {
        return this.acrValues;
    }

    public Map<String, String> getLoginParameters() {
        return this.loginParameters;
    }

    public ArrayList<String> getLoginScopeTokens() {
        return this.loginScopeTokens;
    }

    public int getRequestCode() {
        return this.requestCode;
    }

    public Claims getClaims() {
        return this.claims;
    }

    public int getCustomLoadingLayout() {
        return this.customLoadingLayout;
    }

    public void setAcrValues(String ... acrValues) {
        this.acrValues = new ArrayList<String>(Arrays.asList(acrValues));
    }

    public void setAcrValues(ArrayList<String> acrValues) {
        this.acrValues = acrValues;
    }

    public void setLoginScopeTokens(String ... scopeTokens) {
        this.loginScopeTokens = new ArrayList<String>(Arrays.asList(scopeTokens));
    }

    public void setLoginScopeTokens(ArrayList<String> scopeTokens) {
        this.loginScopeTokens = scopeTokens;
    }

    public void addLoginParameters(Map<String, String> parameters) {
        this.loginParameters = parameters;
    }

    public void setRequestCode(int requestCode) {
        this.requestCode = requestCode;
    }

    public void setClaims(Claims claims) {
        this.claims = claims;
    }

    public void setCustomLoadingLayout(int customLoadingLayout) {
        this.customLoadingLayout = customLoadingLayout;
    }

    protected void startWebViewAuthentication() {
        ConnectSdk.authenticate(this.getActivity(), this.getParameters(), this.getCustomLoadingLayout(), this.getRequestCode());
    }

    @NonNull
    protected Map<String, String> getParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (this.getAcrValues() != null && !this.getAcrValues().isEmpty()) {
            parameters.put("acr_values", TextUtils.join((CharSequence)" ", this.getAcrValues()));
        }
        if (this.getLoginScopeTokens() != null && !this.getLoginScopeTokens().isEmpty()) {
            parameters.put("scope", TextUtils.join((CharSequence)" ", this.getLoginScopeTokens()));
        }
        this.addClaims(parameters);
        if (this.getLoginParameters() != null && !this.getLoginParameters().isEmpty()) {
            parameters.putAll(this.getLoginParameters());
        }
        this.handlePromptAndLogSessionId(parameters);
        return parameters;
    }

    private void addClaims(Map<String, String> parameters) {
        if (this.getClaims() != null && this.getClaims().getClaimsAsSet() != null) {
            try {
                parameters.put("claims", ClaimsParameterFormatter.asJson(this.getClaims()));
            }
            catch (JSONException e) {
                throw new ConnectException("Failed to create claims Json. claims=" + this.getClaims(), e);
            }
        }
    }

    private void handlePromptAndLogSessionId(Map<String, String> parameters) {
        if (TextUtils.isEmpty((CharSequence)parameters.get("prompt")) && !ConnectSdk.isCellularDataNetworkConnected()) {
            parameters.put("prompt", "no_seam");
        }
        if (TextUtils.isEmpty((CharSequence)parameters.get("log_session_id"))) {
            parameters.put("log_session_id", ConnectSdk.getLogSessionId());
        }
    }

    private class LoginClickListener
    implements View.OnClickListener {
        private LoginClickListener() {
        }

        public void onClick(View v) {
            Validator.sdkInitialized();
            ConnectSdk.beforeAuthentication();
            ConnectWebViewLoginButton.this.startWebViewAuthentication();
        }
    }
}

