/*
 * Decompiled with CFR 0.152.
 */
package com.telenor.connect.sms;

import android.webkit.JavascriptInterface;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.telenor.connect.ui.Instruction;
import com.telenor.connect.ui.InstructionHandler;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;

public class HtmlToAndroidInstructionsInterface {
    private final InstructionHandler instructionHandler;
    private static final Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
    private static final Type listOfInstructionsType = new TypeToken<List<Instruction>>(){}.getType();
    private static final List<Instruction> emptyList = Collections.emptyList();

    public HtmlToAndroidInstructionsInterface(InstructionHandler instructionHandler) {
        this.instructionHandler = instructionHandler;
    }

    @JavascriptInterface
    public void processInstructions(String content) {
        List<Instruction> instructions = HtmlToAndroidInstructionsInterface.getAllValidInstructions(content);
        if (!instructions.isEmpty()) {
            this.instructionHandler.givenInstructions(instructions);
        }
    }

    public static List<Instruction> getAllValidInstructions(String potentialInstructionJson) {
        List<Instruction> instructions;
        if (potentialInstructionJson == null || potentialInstructionJson.isEmpty()) {
            return emptyList;
        }
        try {
            instructions = (List<Instruction>)gson.fromJson(potentialInstructionJson, listOfInstructionsType);
        }
        catch (JsonSyntaxException e) {
            return emptyList;
        }
        return HtmlToAndroidInstructionsInterface.allValid(instructions) ? instructions : emptyList;
    }

    private static boolean allValid(List<Instruction> instructions) {
        for (Instruction i : instructions) {
            if (i.isValid()) continue;
            return false;
        }
        return true;
    }
}

