/*
 * Decompiled with CFR 0.152.
 */
package com.telenor.connect.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.jakewharton.retrofit.Ok3Client;
import com.telenor.connect.AnalyticsAPI;
import com.telenor.connect.WellKnownAPI;
import com.telenor.connect.id.ConnectAPI;
import com.telenor.connect.id.IdToken;
import com.telenor.connect.id.IdTokenDeserializer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.client.Client;
import retrofit.converter.Converter;
import retrofit.converter.GsonConverter;

public class RestHelper {
    private static Map<String, ConnectAPI> connectApiMap = new HashMap<String, ConnectAPI>();
    private static Map<String, WellKnownAPI> wellKnownApiMap = new HashMap<String, WellKnownAPI>();
    private static Map<String, AnalyticsAPI> analyticsApiMap = new HashMap<String, AnalyticsAPI>();

    public static ConnectAPI getConnectApi(String endpoint) {
        return RestHelper.getApi(connectApiMap, endpoint, ConnectAPI.class);
    }

    public static WellKnownAPI getWellKnownApi(String endpoint) {
        return RestHelper.getApi(wellKnownApiMap, endpoint, WellKnownAPI.class);
    }

    public static AnalyticsAPI getAnalyticsApi(String endpoint) {
        return RestHelper.getApi(analyticsApiMap, endpoint, AnalyticsAPI.class);
    }

    private static synchronized <T> T getApi(Map<String, T> map, String endpoint, Class<T> type) {
        Object api = map.get(endpoint);
        if (api == null) {
            api = RestHelper.buildApi(endpoint).create(type);
            map.put(endpoint, api);
        }
        return api;
    }

    private static RestAdapter buildApi(String endpoint) {
        OkHttpClient httpClient = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).readTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).build();
        Gson gson = new GsonBuilder().registerTypeAdapter(IdToken.class, (Object)new IdTokenDeserializer()).create();
        RequestInterceptor connectRetroFitInterceptor = new RequestInterceptor(){

            public void intercept(RequestInterceptor.RequestFacade request) {
                request.addHeader("Accept", "application/json");
            }
        };
        return new RestAdapter.Builder().setClient((Client)new Ok3Client(httpClient)).setEndpoint(endpoint).setRequestInterceptor(connectRetroFitInterceptor).setLogLevel(RestAdapter.LogLevel.NONE).setConverter((Converter)new GsonConverter(gson)).build();
    }
}

