/*
 * Decompiled with CFR 0.152.
 */
package com.telenor.connect.utils;

import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import com.telenor.connect.BrowserType;
import com.telenor.connect.ConnectException;
import com.telenor.connect.ConnectSdk;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.HttpUrl;

public class ConnectUrlHelper {
    public static final String ACTION_ARGUMENT = "com.telenor.connect.ACTION_ARGUMENT";
    public static final String OAUTH_PATH = "oauth";

    public static String getPageUrl(Bundle arguments) {
        if ("com.telenor.connect.LOGIN_ACTION".equals(arguments.getString(ACTION_ARGUMENT))) {
            if (arguments.getString("com.telenor.connect.LOGIN_AUTH_URI") == null || arguments.getString("com.telenor.connect.LOGIN_AUTH_URI", "").isEmpty()) {
                throw new IllegalStateException("Required data missing for Login Action.");
            }
            return arguments.getString("com.telenor.connect.LOGIN_AUTH_URI");
        }
        throw new IllegalStateException("An invalid action was used to start a Connect Activity.");
    }

    public static synchronized Uri getAuthorizeUri(Map<String, String> parameters, BrowserType browserType) {
        if (ConnectSdk.getClientId() == null) {
            throw new ConnectException("Client ID not specified in application manifest.");
        }
        if (ConnectSdk.getRedirectUri() == null) {
            throw new ConnectException("Redirect URI not specified in application manifest.");
        }
        if (parameters.get("scope") == null || parameters.get("scope").isEmpty()) {
            throw new IllegalStateException("Cannot log in without scope tokens.");
        }
        parameters.put("state", ConnectSdk.getConnectStore().generateSessionStateParam());
        return ConnectUrlHelper.getAuthorizeUriStem(parameters, ConnectSdk.getClientId(), ConnectSdk.getRedirectUri(), ConnectSdk.getUiLocales(), ConnectUrlHelper.getConnectApiUrl(), browserType).buildUpon().appendPath(OAUTH_PATH).appendPath("authorize").build();
    }

    public static HttpUrl getConnectApiUrl() {
        return new HttpUrl.Builder().scheme("https").host(ConnectSdk.useStaging() ? "connect.staging.telenordigital.com" : "connect.telenordigital.com").build();
    }

    public static Uri getAuthorizeUriStem(Map<String, String> parameters, String clientId, String redirectUri, List<String> locales, HttpUrl basePath, BrowserType browserType) {
        HashMap<String, String> authParameters = new HashMap<String, String>();
        authParameters.put("response_type", "code");
        authParameters.put("client_id", clientId);
        authParameters.put("redirect_uri", redirectUri);
        authParameters.put("ui_locales", TextUtils.join((CharSequence)" ", locales));
        authParameters.put("telenordigital_sdk_version", ConnectUrlHelper.getVersionParam(browserType));
        authParameters.putAll(parameters);
        Uri.Builder builder = new Uri.Builder();
        builder.scheme(basePath.scheme()).authority(basePath.host());
        for (Map.Entry entry : authParameters.entrySet()) {
            builder.appendQueryParameter((String)entry.getKey(), (String)entry.getValue());
        }
        return builder.build();
    }

    private static String getVersionParam(BrowserType browserType) {
        return String.format("android_v%s_%s_%s", "1.4.2", Build.VERSION.RELEASE, browserType != null ? browserType.getVersionString() : "not-defined");
    }

    public static String getWellKnownEndpoint() {
        HttpUrl.Builder builder = ConnectUrlHelper.getConnectApiUrl().newBuilder();
        builder.addPathSegment(OAUTH_PATH);
        for (String pathSegment : "/.well-known/openid-configuration".split("/")) {
            if (TextUtils.isEmpty((CharSequence)pathSegment)) continue;
            builder.addPathSegment(pathSegment);
        }
        String wellKnownEndpoint = builder.build().toString();
        return !ConnectSdk.useStaging() ? wellKnownEndpoint : wellKnownEndpoint.replace("connect.telenordigital.com", "connect.staging.telenordigital.com");
    }
}

