/*
 * Decompiled with CFR 0.152.
 */
package com.telenor.connect.utils;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.os.Build;
import android.webkit.CookieManager;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.telenor.connect.sms.HtmlToAndroidInstructionsInterface;
import com.telenor.connect.ui.ConnectWebViewClient;

public class WebViewHelper {
    private static final int WEB_VIEW_TIMEOUT = 600000;

    @SuppressLint(value={"AddJavascriptInterface", "SetJavaScriptEnabled"})
    @TargetApi(value=21)
    public static void setupWebView(WebView webView, ConnectWebViewClient client, String pageToLoad) {
        webView.setWebViewClient((WebViewClient)client);
        webView.setVerticalScrollBarEnabled(true);
        webView.setHorizontalScrollBarEnabled(false);
        WebSettings settings = webView.getSettings();
        settings.setJavaScriptEnabled(true);
        settings.setSaveFormData(false);
        if (Build.VERSION.SDK_INT >= 21) {
            settings.setMixedContentMode(2);
        }
        webView.addJavascriptInterface((Object)new HtmlToAndroidInstructionsInterface(client), "AndroidInterface");
        webView.setFocusable(true);
        webView.setFocusableInTouchMode(true);
        if (Build.VERSION.SDK_INT >= 19) {
            WebView.setWebContentsDebuggingEnabled((boolean)true);
        }
        WebViewHelper.acceptAllCookies(webView);
        webView.loadUrl(pageToLoad);
        webView.postDelayed((Runnable)new RepeatingDelayedPageReloader(webView, pageToLoad), 600000L);
    }

    private static void acceptAllCookies(WebView webView) {
        CookieManager cookieManager = CookieManager.getInstance();
        cookieManager.setAcceptCookie(true);
        if (Build.VERSION.SDK_INT >= 21) {
            cookieManager.setAcceptThirdPartyCookies(webView, true);
        }
    }

    private static class RepeatingDelayedPageReloader
    implements Runnable {
        private final WebView webView;
        private final String pageToLoad;

        public RepeatingDelayedPageReloader(WebView webView, String pageToLoad) {
            this.webView = webView;
            this.pageToLoad = pageToLoad;
        }

        @Override
        public void run() {
            this.webView.loadUrl(this.pageToLoad);
            this.webView.postDelayed((Runnable)new RepeatingDelayedPageReloader(this.webView, this.pageToLoad), 600000L);
        }
    }
}

