/*
 * Decompiled with CFR 0.152.
 */
package com.telenor.connect.sms;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.google.android.gms.common.api.Status;
import com.telenor.connect.sms.SmsHandler;
import com.telenor.connect.sms.SmsRetrieverUtil;

public class SmsBroadcastReceiver
extends BroadcastReceiver {
    private final SmsHandler smsHandler;

    public SmsBroadcastReceiver(SmsHandler smsHandler) {
        this.smsHandler = smsHandler;
    }

    public void onReceive(Context context, Intent intent) {
        if (!"com.google.android.gms.auth.api.phone.SMS_RETRIEVED".equals(intent.getAction())) {
            return;
        }
        Bundle extras = intent.getExtras();
        if (extras == null) {
            return;
        }
        Status status = (Status)extras.get("com.google.android.gms.auth.api.phone.EXTRA_STATUS");
        if (status == null) {
            return;
        }
        switch (status.getStatusCode()) {
            case 0: {
                String body = (String)extras.get("com.google.android.gms.auth.api.phone.EXTRA_SMS_MESSAGE");
                this.smsHandler.receivedSms(body);
                return;
            }
            case 15: {
                SmsRetrieverUtil.startSmsRetriever(context);
                return;
            }
        }
    }
}

