/*
 * Decompiled with CFR 0.152.
 */
package com.telenor.connect.utils;

import com.nimbusds.jwt.ReadOnlyJWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.telenor.connect.ConnectException;
import com.telenor.connect.ConnectSdk;
import com.telenor.connect.id.IdToken;
import java.text.ParseException;
import java.util.Date;
import java.util.HashSet;
import java.util.List;

public class IdTokenValidator {
    public static void validate(IdToken idToken, Date serverTimestamp) {
        ReadOnlyJWTClaimsSet idTokenClaimsSet;
        try {
            SignedJWT signedJwt = SignedJWT.parse((String)idToken.getSerializedSignedJwt());
            idTokenClaimsSet = signedJwt.getJWTClaimsSet();
        }
        catch (ParseException e) {
            throw new ConnectException("Failed to parse ID token. serializedIdToken=" + idToken.getSerializedSignedJwt(), e);
        }
        String issuer = idTokenClaimsSet.getIssuer();
        String expectedIssuer = ConnectSdk.getExpectedIssuer();
        if (!expectedIssuer.equals(issuer)) {
            throw new ConnectException("ID token issuer is not the same as the issuer this client is configured with. expectedIssuer=" + expectedIssuer + " idTokenClaimsSet=" + idTokenClaimsSet.toJSONObject());
        }
        String clientId = ConnectSdk.getClientId();
        List audience = idTokenClaimsSet.getAudience();
        List<String> expectedAudience = ConnectSdk.getExpectedAudiences();
        if (audience == null || !audience.containsAll(expectedAudience)) {
            throw new ConnectException("ID token audience list does not contain the configured client ID. clientId=" + clientId + " idTokenClaimsSet=" + idTokenClaimsSet.toJSONObject());
        }
        HashSet untrustedAudiences = new HashSet(idTokenClaimsSet.getAudience());
        untrustedAudiences.removeAll(expectedAudience);
        if (untrustedAudiences.size() != 0) {
            throw new ConnectException("ID token audience list contains untrusted audiences. untrustedAudiences=" + untrustedAudiences + " trustedAudiences=" + expectedAudience + " idTokenClaimsSet=" + idTokenClaimsSet.toJSONObject());
        }
        String authorizedParty = (String)idTokenClaimsSet.getCustomClaim("azp");
        if (idTokenClaimsSet.getAudience().size() > 1 && authorizedParty == null) {
            throw new ConnectException("ID token contains multiple audiences but no azp claim is present. idTokenClaimsSet=" + idTokenClaimsSet.toJSONObject());
        }
        if (authorizedParty != null && !clientId.equals(authorizedParty)) {
            throw new ConnectException("ID token authorized party is not the configured client ID. configuredClientId=" + clientId + " idTokenClaimsSet=" + idTokenClaimsSet.toJSONObject());
        }
        Date expirationTime = idTokenClaimsSet.getExpirationTime();
        if (!IdTokenValidator.isValidExpirationTime(expirationTime, new Date(), serverTimestamp)) {
            throw new ConnectException("ID token has expired. idTokenClaimsSet=" + idTokenClaimsSet.toJSONObject());
        }
        if (idTokenClaimsSet.getIssueTime() == null) {
            throw new ConnectException("ID token is missing the \"iat\" claim. idTokenClaimsSet=" + idTokenClaimsSet.toJSONObject());
        }
    }

    public static boolean isValidExpirationTime(Date expirationTime, Date currentDate, Date serverTimestamp) {
        if (expirationTime == null) {
            return false;
        }
        if (expirationTime.after(currentDate)) {
            return true;
        }
        if (serverTimestamp == null) {
            return false;
        }
        return expirationTime.after(serverTimestamp);
    }
}

