/*
 * Decompiled with CFR 0.152.
 */
package com.telenor.connect.utils;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.v4.content.LocalBroadcastManager;
import com.telenor.connect.ConnectCallback;
import com.telenor.connect.ConnectSdk;
import com.telenor.connect.utils.Validator;
import java.util.HashMap;

public class ConnectUtils {
    public static final String LOG_TAG = "ConnectSDK";
    public static final String LOGIN_ACTION = "com.telenor.connect.LOGIN_ACTION";
    public static final String LOGIN_AUTH_URI = "com.telenor.connect.LOGIN_AUTH_URI";
    public static final String LOGIN_STATE = "com.telenor.connect.LOGIN_STATE";
    public static final String PAYMENT_ACTION = "com.telenor.connect.PAYMENT_ACTION";
    public static final String CUSTOM_LOADING_SCREEN_EXTRA = "com.telenor.connect.CUSTOM_LOADING_SCREEN_EXTRA";

    public static void parseAuthCode(String callbackUrl, ConnectCallback callback) {
        Validator.notNullOrEmpty(callbackUrl, "callbackUrl");
        Uri uri = Uri.parse((String)callbackUrl);
        if (!Validator.validState(uri.getQueryParameter("state"))) {
            HashMap<String, String> errorParams = new HashMap<String, String>();
            errorParams.put("error", "state_changed");
            errorParams.put("error_description", "The state parameter was changed between authentication and now");
            callback.onError(errorParams);
            return;
        }
        if (uri.getQueryParameter("error") != null) {
            HashMap<String, String> errorParams = new HashMap<String, String>();
            errorParams.put("error", uri.getQueryParameter("error"));
            errorParams.put("error_description", uri.getQueryParameter("error_description"));
            callback.onError(errorParams);
            return;
        }
        HashMap<String, String> successParams = new HashMap<String, String>();
        successParams.put("code", uri.getQueryParameter("code"));
        successParams.put("state", uri.getQueryParameter("state"));
        callback.onSuccess(successParams);
    }

    public static void sendTokenStateChanged(boolean state) {
        Validator.sdkInitialized();
        LocalBroadcastManager localBroadcastManager = LocalBroadcastManager.getInstance((Context)ConnectSdk.getContext());
        Intent intent = new Intent("com.telenor.connect.ACTION_LOGIN_STATE_CHANGED");
        intent.putExtra(LOGIN_STATE, state);
        localBroadcastManager.sendBroadcast(intent);
    }
}

