/*
 * Decompiled with CFR 0.152.
 */
package com.telenor.connect.ui;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import com.telenor.connect.ConnectException;
import com.telenor.connect.ConnectSdk;
import com.telenor.connect.R;
import com.telenor.connect.id.Claims;
import com.telenor.connect.ui.ConnectButton;
import com.telenor.connect.utils.ClaimsParameterFormatter;
import com.telenor.connect.utils.Validator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;

public class ConnectLoginButton
extends ConnectButton {
    private static final int NO_CUSTOM_LAYOUT = -1;
    private ArrayList<String> acrValues;
    private Map<String, String> loginParameters;
    private ArrayList<String> loginScopeTokens;
    private int requestCode = 43399;
    private Claims claims;
    private int customLoadingLayout = -1;

    public ConnectLoginButton(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.setText(R.string.com_telenor_connect_login_button_text);
        this.setOnClickListener(new LoginClickListener());
    }

    public ArrayList<String> getAcrValues() {
        return this.acrValues;
    }

    public Map<String, String> getLoginParameters() {
        return this.loginParameters;
    }

    public ArrayList<String> getLoginScopeTokens() {
        return this.loginScopeTokens;
    }

    public int getRequestCode() {
        return this.requestCode;
    }

    public Claims getClaims() {
        return this.claims;
    }

    public int getCustomLoadingLayout() {
        return this.customLoadingLayout;
    }

    public void setAcrValues(String ... acrValues) {
        this.acrValues = new ArrayList<String>(Arrays.asList(acrValues));
    }

    public void setAcrValues(ArrayList<String> acrValues) {
        this.acrValues = acrValues;
    }

    public void setLoginScopeTokens(String ... scopeTokens) {
        this.loginScopeTokens = new ArrayList<String>(Arrays.asList(scopeTokens));
    }

    public void setLoginScopeTokens(ArrayList<String> scopeTokens) {
        this.loginScopeTokens = scopeTokens;
    }

    public void addLoginParameters(Map<String, String> parameters) {
        this.loginParameters = parameters;
    }

    public void setRequestCode(int requestCode) {
        this.requestCode = requestCode;
    }

    public void setClaims(Claims claims) {
        this.claims = claims;
    }

    public void setCustomLoadingLayout(int customLoadingLayout) {
        this.customLoadingLayout = customLoadingLayout;
    }

    private class LoginClickListener
    implements View.OnClickListener {
        private LoginClickListener() {
        }

        public void onClick(View v) {
            Validator.sdkInitialized();
            HashMap<String, String> parameters = new HashMap<String, String>();
            if (ConnectLoginButton.this.getAcrValues() != null && !ConnectLoginButton.this.getAcrValues().isEmpty()) {
                parameters.put("acr_values", TextUtils.join((CharSequence)" ", ConnectLoginButton.this.getAcrValues()));
            }
            if (ConnectLoginButton.this.getLoginScopeTokens() != null && !ConnectLoginButton.this.getLoginScopeTokens().isEmpty()) {
                parameters.put("scope", TextUtils.join((CharSequence)" ", ConnectLoginButton.this.getLoginScopeTokens()));
            }
            if (ConnectLoginButton.this.claims != null && ConnectLoginButton.this.claims.getClaims() != null) {
                try {
                    parameters.put("claims", ClaimsParameterFormatter.asJson(ConnectLoginButton.this.claims));
                }
                catch (JSONException e) {
                    throw new ConnectException("Failed to create claims Json. claims=" + ConnectLoginButton.this.claims, e);
                }
            }
            if (ConnectLoginButton.this.getLoginParameters() != null && !ConnectLoginButton.this.getLoginParameters().isEmpty()) {
                parameters.putAll(ConnectLoginButton.this.getLoginParameters());
            }
            if (ConnectLoginButton.this.customLoadingLayout == -1) {
                ConnectSdk.authenticate(ConnectLoginButton.this.getActivity(), parameters, ConnectLoginButton.this.requestCode);
            } else {
                ConnectSdk.authenticate(ConnectLoginButton.this.getActivity(), parameters, ConnectLoginButton.this.customLoadingLayout, ConnectLoginButton.this.requestCode);
            }
        }
    }
}

