/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.api;

import com.perforce.api.Env;
import com.perforce.api.HashDecay;
import com.perforce.api.P4Process;
import com.perforce.api.PerforceException;
import com.perforce.api.SourceControlObject;
import java.io.IOException;
import java.util.Enumeration;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class User
extends SourceControlObject {
    private String id = "";
    private String email = "";
    private String fullname = "";
    private static HashDecay users = null;
    private static final Logger logger = Logger.getLogger(User.class);

    public User() {
        this.getCache();
    }

    public User(String id) {
        this();
        this.id = id;
    }

    private static HashDecay setCache() {
        if (null == users) {
            users = new HashDecay(600000L);
            users.start();
        }
        return users;
    }

    @Override
    public HashDecay getCache() {
        return User.setCache();
    }

    public void setId(String id) {
        this.id = id;
    }

    public static synchronized Enumeration<User> getUsers() throws PerforceException {
        return User.getUsers(null);
    }

    public static synchronized Enumeration<User> getUsers(Env env) throws PerforceException {
        String[] cmd = new String[]{"p4", "users"};
        P4Process p = new P4Process(env);
        try {
            String l;
            p.exec(cmd);
            while (null != (l = p.readLine())) {
                if (l.startsWith("#")) continue;
                User.getUser(env, l);
            }
        }
        catch (IOException ex) {
            throw new PerforceException(ex.getMessage(), ex);
        }
        finally {
            try {
                p.close();
            }
            catch (IOException e) {
                throw new PerforceException(e.getMessage(), e);
            }
        }
        return User.setCache().elements();
    }

    public static synchronized User getUser(String uid) {
        return User.getUser(null, uid);
    }

    public static synchronized User getUser(Env env, String uid) {
        if (null == uid) {
            return null;
        }
        if (uid.trim().equals("")) {
            return null;
        }
        int left = 0;
        left = (uid = uid.trim()).indexOf("<");
        String tid = -1 == left ? uid : uid.substring(0, left - 1).trim();
        User u = (User)User.setCache().get(uid);
        if (null != u) {
            return u;
        }
        u = new User(tid);
        u.setEmail(tid);
        u.setFullName(tid);
        if (-1 != left) {
            uid = uid.substring(left + 1);
            char[] ch = uid.toCharArray();
            left = 0;
            block5: for (int i = 0; i < ch.length; ++i) {
                switch (ch[i]) {
                    case '>': {
                        u.setEmail(new String(ch, left, i - left));
                        continue block5;
                    }
                    case '(': {
                        left = i + 1;
                        continue block5;
                    }
                    case ')': {
                        u.setFullName(new String(ch, left, i - left));
                    }
                }
            }
        }
        u.setEnv(env);
        users.put((Object)tid, u);
        return u;
    }

    public String getId() {
        return this.id;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getEmail() {
        return this.email;
    }

    public void setFullName(String fullname) {
        this.fullname = fullname;
    }

    public String getFullName() {
        return this.fullname;
    }

    @Override
    public void commit() {
    }

    public void sync(String id) {
        this.id = id;
        this.sync();
    }

    @Override
    public void sync() {
        if (!this.outOfSync(300000L)) {
            return;
        }
        String[] cmd = new String[]{"p4", "user", "-o", "id"};
        cmd[3] = this.id;
        try {
            String l;
            P4Process p = new P4Process(this.getEnv());
            p.exec(cmd);
            while (null != (l = p.readLine())) {
                if (l.startsWith("#")) continue;
                if (l.startsWith("User:")) {
                    this.id = l.substring(6).trim();
                    continue;
                }
                if (l.startsWith("Email:")) {
                    this.email = l.substring(7).trim();
                    continue;
                }
                if (!l.startsWith("FullName:")) continue;
                this.fullname = l.substring(10).trim();
            }
            p.close();
            this.inSync();
        }
        catch (IOException ex) {
            logger.error((Object)ex);
        }
    }

    public String toString() {
        return this.id;
    }

    @Override
    public String toXML() {
        StringBuffer sb = new StringBuffer("<user id=\"");
        sb.append(this.getId());
        sb.append("\" fullname=\"");
        sb.append(this.getFullName());
        sb.append("\" email=\"");
        sb.append(this.getEmail());
        sb.append("\"/>");
        return sb.toString();
    }
}

