package com.tek42.perforce.process;

import java.util.Map;

import java.util.HashMap;
import java.io.File;

/**
 * Default @{link ExecutorFactory} that handles creating new {@link CmdLineExecutor}s
 * 
 * @author Mike Wille
 */
public class DefaultExecutorFactory implements ExecutorFactory {

	Map<String, String> env;
    File runningDirectory;

    /*
	 * (non-Javadoc)
	 * 
	 * @see com.tek42.perforce.process.ExecutorFactory#newExecutor()
	 */
	public Executor newExecutor()
    {
        if (runningDirectory != null)
        {
            return new CmdLineExecutor(env, runningDirectory);
        }
        else
        {
            return new CmdLineExecutor(env);
        }
    }

    /*
	 * (non-Javadoc)
	 * 
	 * @see com.tek42.perforce.process.ExecutorFactory#setEnv(java.util.Map)
	 */
	public void setEnv(Map<String, String> env)
    {
		this.env = new HashMap<String, String>(env);
	}

    public void setRunningDirectory(File runningDirectory)
    {
        this.runningDirectory = runningDirectory;
    }
}
