/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swt.internal.platform;

import com.teamdev.jxbrowser.internal.reflect.Classes;
import java.util.Optional;

enum GtkVersion {
    GTK_3;


    public static GtkVersion detect() {
        Optional<GtkVersion> fromProperty = GtkVersion.extractVersionFromProperty();
        return fromProperty.orElseGet(GtkVersion::fromClassPath);
    }

    private static GtkVersion fromClassPath() {
        if (Classes.exists((String)"org.eclipse.swt.internal.gtk.GTK")) {
            return GTK_3;
        }
        throw new IllegalStateException("Failed to detect the GTK version");
    }

    private static Optional<GtkVersion> extractVersionFromProperty() {
        String versionProperty = System.getProperty("org.eclipse.swt.internal.gtk.version");
        if (versionProperty != null) {
            if (versionProperty.startsWith("3")) {
                return Optional.of(GTK_3);
            }
            throw new IllegalStateException("SWT uses unsupported GTK version: " + versionProperty);
        }
        return Optional.empty();
    }
}

