/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swt.internal.menu;

import com.teamdev.jxbrowser.browser.callback.ShowContextMenuCallback;
import com.teamdev.jxbrowser.menu.ContextMenuItem;
import com.teamdev.jxbrowser.menu.ContextMenuItemType;
import com.teamdev.jxbrowser.view.swt.internal.menu.ContextMenu;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public final class CustomContextMenu
extends ContextMenu {
    private final List<ContextMenuItem> items;

    public CustomContextMenu(List<ContextMenuItem> items) {
        this.items = items;
    }

    @Override
    public void init(Menu menu, ShowContextMenuCallback.Action callback) {
        this.items.forEach(item -> this.buildPopupMenu(menu, (ContextMenuItem)item, callback));
    }

    private void buildPopupMenu(Menu popupMenu, ContextMenuItem item, ShowContextMenuCallback.Action callback) {
        ContextMenuItemType itemType = item.type();
        if (itemType == ContextMenuItemType.ITEM) {
            this.buildMenuItem(popupMenu, item, callback);
        } else if (itemType == ContextMenuItemType.CHECKABLE_ITEM) {
            this.buildCheckedMenuItem(popupMenu, item, callback);
        } else if (itemType == ContextMenuItemType.SUB_MENU) {
            this.buildMenu(popupMenu, item, callback);
        } else if (itemType == ContextMenuItemType.SEPARATOR) {
            new MenuItem(popupMenu, 2);
        }
    }

    private void buildMenu(Menu menu, ContextMenuItem item, ShowContextMenuCallback.Action callback) {
        MenuItem menuItemToInsert = new MenuItem(menu, 64);
        menuItemToInsert.setText(item.text());
        Menu popupMenu = new Menu(menu);
        for (ContextMenuItem menuItem : item.items()) {
            this.buildPopupMenu(popupMenu, menuItem, callback);
        }
        menuItemToInsert.setMenu(popupMenu);
    }

    private void buildMenuItem(Menu menu, final ContextMenuItem item, final ShowContextMenuCallback.Action callback) {
        MenuItem menuItem = new MenuItem(menu, 8);
        menuItem.setText(item.text());
        menuItem.setEnabled(item.isEnabled());
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                callback.select(item);
            }
        });
    }

    private void buildCheckedMenuItem(Menu menu, final ContextMenuItem item, final ShowContextMenuCallback.Action callback) {
        MenuItem menuItem = new MenuItem(menu, 32);
        menuItem.setText(item.text());
        menuItem.setSelection(item.isChecked());
        menuItem.setEnabled(item.isEnabled());
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                callback.select(item);
            }
        });
    }
}

