/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swt.internal.dialog;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableList;
import com.teamdev.jxbrowser.internal.string.StringPreconditions;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class CustomDialog
extends Dialog {
    private final String message;
    private final List<ButtonData> buttons;
    private int selectedActionId;

    CustomDialog(Builder<?, ?> builder) {
        super(((Builder)builder).parent, 67680);
        this.message = ((Builder)builder).message;
        this.buttons = ((Builder)builder).buttons.build();
        if (((Builder)builder).title != null) {
            this.setText(((Builder)builder).title);
        }
    }

    protected abstract Composite createContents(Composite var1);

    public final int open() {
        Shell shell = new Shell(this.getParent(), this.getStyle());
        shell.setText(this.getText());
        this.initContents(shell);
        shell.pack();
        shell.open();
        Display display = this.getParent().getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.selectedActionId;
    }

    private void initContents(Shell shell) {
        shell.setLayout((Layout)new GridLayout(2, true));
        Composite contents = this.createContents((Composite)shell);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        contents.setLayoutData((Object)data);
        for (ButtonData buttonData : this.buttons) {
            Button button = new Button((Composite)shell, 8);
            button.setText(buttonData.text);
            button.addListener(13, event -> {
                this.selectedActionId = buttonData.actionId;
                shell.close();
            });
        }
    }

    protected final void putDisplayedMessage(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(this.message);
    }

    private static final class ButtonData {
        private final String text;
        private final int actionId;

        private ButtonData(String text, int actionId) {
            this.text = text;
            this.actionId = actionId;
        }
    }

    protected static abstract class Builder<D extends CustomDialog, B extends Builder<D, B>> {
        private final Shell parent;
        private final String message;
        private final ImmutableList.Builder<ButtonData> buttons;
        private String title;

        protected Builder(Shell parent, String message) {
            StringPreconditions.checkNotNullEmptyOrBlank((String)message);
            this.parent = (Shell)Preconditions.checkNotNull((Object)parent);
            this.message = message;
            this.buttons = ImmutableList.builder();
        }

        public B title(String title) {
            StringPreconditions.checkNotNullEmptyOrBlank((String)title);
            this.title = title;
            return this.self();
        }

        public B addButton(String text, int actionId) {
            StringPreconditions.checkNotNullEmptyOrBlank((String)text);
            this.buttons.add((Object)new ButtonData(text, actionId));
            return this.self();
        }

        public abstract D build();

        protected abstract B self();
    }
}

