/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swt.internal;

import com.teamdev.jxbrowser.browser.event.BrowserClosing;
import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableSet;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.internal.Display;
import com.teamdev.jxbrowser.internal.ToolkitLibrary;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.view.swt.BrowserView;
import com.teamdev.jxbrowser.view.swt.internal.BrowserComposite;
import com.teamdev.jxbrowser.view.swt.internal.FocusAdapter;
import com.teamdev.jxbrowser.view.swt.internal.NativeAwareControl;
import com.teamdev.jxbrowser.view.swt.internal.NativeAwareShell;
import com.teamdev.jxbrowser.view.swt.internal.SafeExecutor;
import com.teamdev.jxbrowser.view.swt.internal.WindowedWidgetBounds;
import com.teamdev.jxbrowser.view.swt.internal.platform.GtkLibrary;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

final class WindowedWidget
extends BrowserComposite
implements NativeAwareControl {
    private static final Set<WindowedWidget> displayedInstances = Collections.synchronizedSet(new HashSet());
    private final Display primaryDisplay;
    private final Listener showListener;
    private final Listener hideListener;
    private final ControlListener controlListener;
    private final FocusAdapter focusAdapter;
    private final Subscription browserClosing;
    private State state = State.HIDDEN;

    WindowedWidget(BrowserView parent, BrowserWidget widget) {
        super(parent, 0x1000000, widget);
        BrowserImpl browser = widget.browser();
        this.focusAdapter = FocusAdapter.newInstance(this);
        this.browserClosing = browser.on(BrowserClosing.class, event -> SafeExecutor.asyncExec((Widget)this, this::close));
        this.addDisposeListener(disposeEvent -> this.close());
        this.primaryDisplay = Display.primaryDisplay();
        this.showListener = new ShowListener();
        this.hideListener = new HideListener();
        this.controlListener = new ControlResizedListener();
        this.registerVisibilityListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ImmutableSet<WindowedWidget> displayedWidgets() {
        Set<WindowedWidget> set = displayedInstances;
        synchronized (set) {
            return ImmutableSet.copyOf(displayedInstances);
        }
    }

    public BrowserView getParent() {
        return (BrowserView)super.getParent();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            SafeExecutor.asyncExec((Widget)this, this::showRenderWidget);
        } else {
            this.hide();
        }
    }

    void unfocusBrowserWidget() {
        BrowserWidget widget = this.browserWidget();
        if (!widget.isClosed()) {
            widget.unfocus();
        }
    }

    void focusBrowserWidget() {
        BrowserWidget widget = this.browserWidget();
        if (!widget.isClosed()) {
            widget.focus();
        }
    }

    @Override
    protected void close() {
        this.hide();
        this.unregisterVisibilityListeners();
        this.browserClosing.unsubscribe();
        this.focusAdapter.stopEventProcessing();
        super.close();
    }

    @Override
    void showRenderWidget() {
        if (this.state == State.SHOWING) {
            return;
        }
        Shell shell = this.getShell();
        this.displayWatcher().attach(new NativeAwareShell(shell));
        this.shellListeners().attach(shell);
        this.focusAdapter.startEventProcessing();
        this.addControlListener(this.controlListener);
        this.attachWidget();
        this.browserWidget().show();
        displayedInstances.add(this);
        this.state = State.SHOWING;
        this.notifyBoundsUpdated();
    }

    @Override
    void notifyBoundsUpdated() {
        this.checkWidget();
        if (this.state != State.SHOWING) {
            return;
        }
        WindowedWidgetBounds bounds = WindowedWidgetBounds.calculateFor(this, this.primaryDisplay);
        this.browserWidget().bounds(bounds.inWindow(), bounds.inScreen());
    }

    private void attachWidget() {
        long componentHandle = this.nativeHandle();
        BrowserWidget widget = this.browserWidget();
        if (Environment.isLinux()) {
            long socketHandle = GtkLibrary.instance().socketHandle(this);
            long chromiumXWindow = widget.chromiumWindowHandle();
            ToolkitLibrary.instance().embedToGtkSocket(socketHandle, chromiumXWindow);
            widget.onParentWindowChanged(componentHandle);
            widget.show();
        } else {
            widget.attach(componentHandle);
        }
    }

    private void hide() {
        if (this.state == State.HIDDEN) {
            return;
        }
        this.displayWatcher().detach();
        this.shellListeners().detach();
        this.focusAdapter.stopEventProcessing();
        this.removeControlListener(this.controlListener);
        displayedInstances.remove(this);
        BrowserWidget widget = this.browserWidget();
        if (!widget.isClosed()) {
            widget.hide();
        }
        this.state = State.HIDDEN;
    }

    private void registerVisibilityListeners() {
        this.addListener(22, this.showListener);
        this.addListener(23, this.hideListener);
    }

    private void unregisterVisibilityListeners() {
        this.removeListener(22, this.showListener);
        this.removeListener(23, this.hideListener);
    }

    @Override
    protected void onMovedToDisplay(Display osDisplay) {
        super.onMovedToDisplay(osDisplay);
        this.notifyBoundsUpdated();
    }

    private class HideListener
    implements Listener {
        private HideListener() {
        }

        public void handleEvent(Event event) {
            WindowedWidget.this.hide();
        }
    }

    private class ShowListener
    implements Listener {
        private ShowListener() {
        }

        public void handleEvent(Event event) {
            WindowedWidget.this.showRenderWidget();
        }
    }

    private class ControlResizedListener
    extends ControlAdapter {
        private ControlResizedListener() {
        }

        public void controlResized(ControlEvent controlEvent) {
            WindowedWidget.this.notifyBoundsUpdated();
        }
    }

    private static enum State {
        SHOWING,
        HIDDEN;

    }
}

