/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swt.internal;

import com.teamdev.jxbrowser.internal.SystemProperties;
import java.util.Optional;

final class SwtAutoScaleProperty {
    private static final String NAME = "swt.autoScale";

    private SwtAutoScaleProperty() {
    }

    static Optional<Double> doubleValue() {
        if (!SystemProperties.hasProperty((String)NAME)) {
            return Optional.empty();
        }
        String autoScale = System.getProperty(NAME);
        try {
            int autoScaleValue = Integer.parseInt(autoScale);
            double scaleFactor = SwtAutoScaleProperty.valueWithinBounds(autoScaleValue) / DpiZoomLevel.DEFAULT.value;
            return Optional.of(scaleFactor);
        }
        catch (NumberFormatException numberFormatException) {
            return Optional.empty();
        }
    }

    private static double valueWithinBounds(int autoScaleValue) {
        return Math.max(Math.min((double)autoScaleValue, DpiZoomLevel.MAX.value), DpiZoomLevel.MIN.value);
    }

    private static enum DpiZoomLevel {
        MAX(1600.0),
        DEFAULT(100.0),
        MIN(25.0);

        private final double value;

        private DpiZoomLevel(double value) {
            this.value = value;
        }
    }
}

