/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swt.internal;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import java.util.function.Consumer;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;

public final class SafeExecutor {
    public static void asyncExec(Widget widget, Runnable doRun) {
        Preconditions.checkNotNull((Object)widget);
        Preconditions.checkNotNull((Object)doRun);
        if (widget.isDisposed()) {
            return;
        }
        SafeExecutor.executeSilently(widget, arg_0 -> ((Display)widget.getDisplay()).asyncExec(arg_0), doRun);
    }

    public static void asyncExec(Widget widget, Runnable doRun, Runnable doFail) {
        Preconditions.checkNotNull((Object)widget);
        Preconditions.checkNotNull((Object)doRun);
        Preconditions.checkNotNull((Object)doFail);
        if (widget.isDisposed()) {
            return;
        }
        try {
            widget.getDisplay().asyncExec(() -> {
                if (widget.isDisposed()) {
                    doFail.run();
                } else {
                    doRun.run();
                }
            });
        }
        catch (SWTException ignore) {
            doFail.run();
        }
    }

    private SafeExecutor() {
    }

    private static void executeSilently(Widget widget, Consumer<Runnable> executor, Runnable doRun) {
        try {
            executor.accept(() -> {
                if (!widget.isDisposed()) {
                    doRun.run();
                }
            });
        }
        catch (SWTException sWTException) {
            // empty catch block
        }
    }
}

