/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swt.internal;

import com.teamdev.jxbrowser.browser.event.BrowserClosing;
import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.browser.internal.rpc.CursorChanged;
import com.teamdev.jxbrowser.browser.internal.rpc.DoneTabbing;
import com.teamdev.jxbrowser.browser.internal.rpc.TooltipChanged;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.ui.KeyCode;
import com.teamdev.jxbrowser.ui.KeyLocation;
import com.teamdev.jxbrowser.ui.KeyModifiers;
import com.teamdev.jxbrowser.ui.MouseButton;
import com.teamdev.jxbrowser.ui.MouseModifiers;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.ui.Rect;
import com.teamdev.jxbrowser.ui.ScrollType;
import com.teamdev.jxbrowser.ui.event.KeyPressed;
import com.teamdev.jxbrowser.ui.event.KeyReleased;
import com.teamdev.jxbrowser.ui.event.KeyTyped;
import com.teamdev.jxbrowser.ui.event.MouseDragged;
import com.teamdev.jxbrowser.ui.event.MouseEntered;
import com.teamdev.jxbrowser.ui.event.MouseExited;
import com.teamdev.jxbrowser.ui.event.MouseMoved;
import com.teamdev.jxbrowser.ui.event.MousePressed;
import com.teamdev.jxbrowser.ui.event.MouseReleased;
import com.teamdev.jxbrowser.ui.event.MouseWheel;
import com.teamdev.jxbrowser.ui.internal.Geometry;
import com.teamdev.jxbrowser.view.swt.BrowserView;
import com.teamdev.jxbrowser.view.swt.internal.BrowserComposite;
import com.teamdev.jxbrowser.view.swt.internal.EclipsePartVisibilityTracker;
import com.teamdev.jxbrowser.view.swt.internal.EclipseWorkbenchDetector;
import com.teamdev.jxbrowser.view.swt.internal.NativeAwareControl;
import com.teamdev.jxbrowser.view.swt.internal.NativeAwareShell;
import com.teamdev.jxbrowser.view.swt.internal.NativeKeyCodes;
import com.teamdev.jxbrowser.view.swt.internal.SafeExecutor;
import com.teamdev.jxbrowser.view.swt.internal.SwtCursorFactory;
import com.teamdev.jxbrowser.view.swt.internal.SwtMouseButton;
import com.teamdev.jxbrowser.view.swt.internal.TabbingAssistant;
import java.util.Optional;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

class OffScreenRenderWidget
extends BrowserComposite
implements NativeAwareControl {
    final KeyListener keyListener;
    final MouseListener mouseListener;
    final MouseWheelListener mouseWheelListener;
    final MouseMotionListener mouseMoveListener;
    final MouseTrackListener mouseTrackListener;
    private final Listener showListener;
    private final Listener hideListener;
    private final FocusListener focusListener;
    private final ControlListener resizeListener;
    private final TabbingAssistant tabbingAssistant;
    private final Subscription browserClosing;
    private final NativeKeyCodes nativeKeyCodes;
    private EclipsePartVisibilityTracker eclipsePartVisibilityTracker;
    private Subscription doneTabbing;
    private Subscription cursorChanged;
    private Subscription tooltipChanged;
    private boolean visible;

    OffScreenRenderWidget(BrowserView parent, BrowserWidget widget) {
        super(parent, 262144, widget);
        BrowserImpl browser = widget.browser();
        browser.dragAndDrop().disable();
        this.nativeKeyCodes = new NativeKeyCodes();
        this.keyListener = new KeyListener();
        this.mouseListener = new MouseListener();
        this.focusListener = new FocusListener();
        this.resizeListener = new ResizeListener();
        this.mouseWheelListener = new MouseWheelListener();
        this.mouseMoveListener = new MouseMotionListener();
        this.mouseTrackListener = new MouseTrackListener();
        this.showListener = new ShowListener();
        this.hideListener = new HideListener();
        this.tabbingAssistant = new TabbingAssistant(parent);
        this.addTraverseListener(e -> {
            e.doit = false;
        });
        this.addDisposeListener(e -> this.close());
        this.addListener(22, this.showListener);
        this.addListener(23, this.hideListener);
        if (EclipseWorkbenchDetector.inEclipseWorkbench(this)) {
            this.eclipsePartVisibilityTracker = EclipsePartVisibilityTracker.newBuilder(this).showListener(this.showListener).hideListener(this.hideListener).build();
            this.eclipsePartVisibilityTracker.start();
        }
        this.browserClosing = browser.on(BrowserClosing.class, event -> SafeExecutor.asyncExec((Widget)this, this::close));
    }

    @Override
    protected void close() {
        if (EclipseWorkbenchDetector.inEclipseWorkbench(this)) {
            this.eclipsePartVisibilityTracker.stop();
        }
        this.hideRenderWidget();
        this.removeListener(22, this.showListener);
        this.removeListener(23, this.hideListener);
        this.browserClosing.unsubscribe();
        super.close();
    }

    @Override
    protected void onHierarchyChanged() {
        super.onHierarchyChanged();
        if (EclipseWorkbenchDetector.inEclipseWorkbench(this)) {
            this.eclipsePartVisibilityTracker.reattach();
        }
    }

    final boolean isShown() {
        return this.visible;
    }

    @Override
    protected void showRenderWidget() {
        if (this.isShown()) {
            return;
        }
        this.addMouseListeners();
        this.addWindowListeners();
        this.addKeyListener((org.eclipse.swt.events.KeyListener)this.keyListener);
        this.addFocusListener((org.eclipse.swt.events.FocusListener)this.focusListener);
        this.addControlListener(this.resizeListener);
        BrowserWidget widget = this.browserWidget();
        widget.attach(this.nativeHandle());
        widget.show();
        this.cursorChanged = widget.on(CursorChanged.class, event -> {
            try {
                SafeExecutor.asyncExec((Widget)this, () -> this.setCursor((Cursor)this.cursorFactory().newCursor((CursorChanged)event)));
            }
            catch (Exception e) {
                Logger.error((String)"Failed to change cursor", (Throwable)e);
            }
        });
        this.tooltipChanged = widget.on(TooltipChanged.class, event -> SafeExecutor.asyncExec((Widget)this, () -> {
            String text = event.getTooltipText();
            if (text.isEmpty()) {
                this.setToolTipText(null);
            } else {
                this.setToolTipText(text);
            }
        }));
        this.doneTabbing = widget.on(DoneTabbing.class, event -> SafeExecutor.asyncExec((Widget)this, () -> {
            if (event.getReason() == DoneTabbing.Reason.DONE_TABBING_NEXT) {
                this.tabbingAssistant.passFocusToNext();
            } else {
                this.tabbingAssistant.passFocusToPrev();
            }
        }));
        this.notifyBoundsUpdated();
        this.visible = true;
    }

    protected void hideRenderWidget() {
        BrowserWidget widget;
        if (!this.isShown()) {
            return;
        }
        if (this.browserClosing != null) {
            this.browserClosing.unsubscribe();
        }
        if (this.cursorChanged != null) {
            this.cursorChanged.unsubscribe();
        }
        if (this.tooltipChanged != null) {
            this.tooltipChanged.unsubscribe();
        }
        if (this.doneTabbing != null) {
            this.doneTabbing.unsubscribe();
        }
        if (!(widget = this.browserWidget()).isClosed()) {
            widget.hide();
        }
        this.removeKeyListener((org.eclipse.swt.events.KeyListener)this.keyListener);
        this.removeControlListener(this.resizeListener);
        this.removeFocusListener((org.eclipse.swt.events.FocusListener)this.focusListener);
        this.removeWindowListeners();
        this.removeMouseListeners();
        this.visible = false;
    }

    private void addWindowListeners() {
        Shell shell = this.getShell();
        this.shellListeners().attach(shell);
        this.displayWatcher().attach(new NativeAwareShell(shell));
    }

    private void removeWindowListeners() {
        this.shellListeners().detach();
        this.displayWatcher().detach();
    }

    private void addMouseListeners() {
        this.addMouseListener((org.eclipse.swt.events.MouseListener)this.mouseListener);
        this.addMouseMoveListener(this.mouseMoveListener);
        this.addMouseTrackListener((org.eclipse.swt.events.MouseTrackListener)this.mouseTrackListener);
        this.addMouseWheelListener(this.mouseWheelListener);
    }

    private void removeMouseListeners() {
        this.removeMouseListener((org.eclipse.swt.events.MouseListener)this.mouseListener);
        this.removeMouseMoveListener(this.mouseMoveListener);
        this.removeMouseTrackListener((org.eclipse.swt.events.MouseTrackListener)this.mouseTrackListener);
        this.removeMouseWheelListener(this.mouseWheelListener);
    }

    public void setBounds(Rectangle r) {
        super.setBounds(r);
        this.notifyBoundsUpdated();
    }

    @Override
    void notifyBoundsUpdated() {
        org.eclipse.swt.graphics.Point location = this.toDisplay(1, 1);
        Rectangle bounds = this.getBounds();
        Rect boundsInParent = Geometry.newRect((double)bounds.x, (double)bounds.y, (double)bounds.width, (double)bounds.height);
        Rect boundsInScreen = Geometry.newRect((double)location.x, (double)location.y, (double)bounds.width, (double)bounds.height);
        if (!boundsInParent.size().isEmpty()) {
            this.browserWidget().bounds(boundsInParent, boundsInScreen);
        }
    }

    private void dispatchMouseDragged(MouseEvent event) {
        Optional<MouseButton> mouseButton = this.draggedMouseButton(event);
        if (!mouseButton.isPresent()) {
            return;
        }
        this.browserWidget().dispatch(MouseDragged.newBuilder((Point)this.localPoint(event)).locationOnScreen(this.screenPoint(event)).button(mouseButton.get()).mouseModifiers(OffScreenRenderWidget.mouseModifiers(event)).keyModifiers(this.keyModifiers(event)).build());
    }

    private Optional<MouseButton> draggedMouseButton(MouseEvent event) {
        if ((event.stateMask & 0x80000) != 0) {
            return Optional.of(MouseButton.PRIMARY);
        }
        if ((event.stateMask & 0x100000) != 0) {
            return Optional.of(MouseButton.MIDDLE);
        }
        if ((event.stateMask & 0x200000) != 0) {
            return Optional.of(MouseButton.SECONDARY);
        }
        return Optional.empty();
    }

    private KeyModifiers keyModifiers(KeyEvent e) {
        return KeyModifiers.newBuilder().altDown(this.isAltDown(e)).altGraphDown(this.isAltGraphDown(e)).shiftDown(this.isShiftDown(e)).controlDown(this.isControlDown(e)).metaDown(this.isMetaDown(e)).build();
    }

    private KeyModifiers keyModifiers(MouseEvent event) {
        KeyModifiers.Builder builder = KeyModifiers.newBuilder().altDown(this.isAltDown(event)).altGraphDown(this.isAltGraphDown(event)).shiftDown(this.isShiftDown(event)).controlDown(this.isControlDown(event)).metaDown(this.isMetaDown(event));
        return builder.build();
    }

    private KeyLocation keyLocation(KeyEvent e) {
        if (e.keyLocation == 2) {
            return KeyLocation.NUMERIC_KEYPAD;
        }
        if (e.keyLocation == 16384) {
            return KeyLocation.LEFT;
        }
        if (e.keyLocation == 131072) {
            return KeyLocation.RIGHT;
        }
        return KeyLocation.STANDARD;
    }

    private boolean isMetaDown(MouseEvent event) {
        return (event.stateMask & 0x400000) != 0;
    }

    private boolean isMetaDown(KeyEvent event) {
        return (event.stateMask & 0x400000) != 0;
    }

    private boolean isControlDown(MouseEvent event) {
        return (event.stateMask & 0x40000) != 0;
    }

    private boolean isControlDown(KeyEvent event) {
        return (event.stateMask & 0x40000) != 0;
    }

    private boolean isShiftDown(MouseEvent event) {
        return (event.stateMask & 0x20000) != 0;
    }

    private boolean isShiftDown(KeyEvent event) {
        return (event.stateMask & 0x20000) != 0;
    }

    private boolean isAltGraphDown(MouseEvent event) {
        return this.isAltDown(event) && (event.stateMask & 0x20000) != 0;
    }

    private boolean isAltGraphDown(KeyEvent event) {
        return this.isAltDown(event) && (event.stateMask & 0x20000) != 0;
    }

    private boolean isAltDown(MouseEvent event) {
        return (event.stateMask & 0x10000) != 0;
    }

    private boolean isAltDown(KeyEvent event) {
        return (event.stateMask & 0x10000) != 0;
    }

    private static MouseModifiers mouseModifiers(MouseEvent event) {
        return MouseModifiers.newBuilder().primaryButtonDown(OffScreenRenderWidget.hasModifier(event, 524288) || OffScreenRenderWidget.isPressed(event, MouseButton.PRIMARY)).middleButtonDown(OffScreenRenderWidget.hasModifier(event, 0x100000) || OffScreenRenderWidget.isPressed(event, MouseButton.MIDDLE)).secondaryButtonDown(OffScreenRenderWidget.hasModifier(event, 0x200000) || OffScreenRenderWidget.isPressed(event, MouseButton.SECONDARY)).build();
    }

    private static boolean hasModifier(MouseEvent event, int buttonMask) {
        int stateMask = event.stateMask;
        return (stateMask & buttonMask) == buttonMask;
    }

    private static boolean isPressed(MouseEvent event, MouseButton button) {
        return OffScreenRenderWidget.mouseButton(event) == button;
    }

    private void dispatchMouseMoved(MouseEvent event) {
        this.browserWidget().dispatch(MouseMoved.newBuilder((Point)this.localPoint(event)).locationOnScreen(this.screenPoint(event)).mouseModifiers(OffScreenRenderWidget.mouseModifiers(event)).keyModifiers(this.keyModifiers(event)).build());
    }

    private static MouseButton mouseButton(MouseEvent event) {
        if (event.button == SwtMouseButton.FIRST.value()) {
            return MouseButton.PRIMARY;
        }
        if (event.button == SwtMouseButton.SECOND.value()) {
            return MouseButton.MIDDLE;
        }
        if (event.button == SwtMouseButton.THIRD.value()) {
            return MouseButton.SECONDARY;
        }
        return MouseButton.MOUSE_BUTTON_UNSPECIFIED;
    }

    private Point localPoint(MouseEvent event) {
        return Geometry.newPoint((double)event.x, (double)event.y);
    }

    private Point screenPoint(MouseEvent event) {
        org.eclipse.swt.graphics.Point location = OffScreenRenderWidget.locationOnScreenSafe((Composite)event.widget);
        int globalX = location.x + event.x;
        int globalY = location.y + event.y;
        return Geometry.newPoint((double)globalX, (double)globalY);
    }

    private static org.eclipse.swt.graphics.Point locationOnScreenSafe(Composite composite) {
        return composite.isVisible() ? composite.toDisplay(1, 1) : new org.eclipse.swt.graphics.Point(0, 0);
    }

    private void requestFocusIfNecessary() {
        if (!this.isFocusControl()) {
            this.setFocus();
        }
    }

    private SwtCursorFactory cursorFactory() {
        return SwtCursorFactory.forDevice((Device)this.getDisplay());
    }

    private class HideListener
    implements Listener {
        private HideListener() {
        }

        public void handleEvent(Event event) {
            OffScreenRenderWidget.this.hideRenderWidget();
        }
    }

    private class ShowListener
    implements Listener {
        private ShowListener() {
        }

        public void handleEvent(Event event) {
            OffScreenRenderWidget.this.showRenderWidget();
        }
    }

    private class FocusListener
    extends FocusAdapter {
        private FocusListener() {
        }

        public void focusGained(FocusEvent e) {
            OffScreenRenderWidget.this.browserWidget().focus();
        }

        public void focusLost(FocusEvent e) {
            OffScreenRenderWidget.this.browserWidget().unfocus();
        }
    }

    private class ResizeListener
    extends ControlAdapter {
        private ResizeListener() {
        }

        public void controlResized(ControlEvent e) {
            OffScreenRenderWidget.this.setBounds(OffScreenRenderWidget.this.getBounds());
        }
    }

    final class KeyListener
    extends KeyAdapter {
        KeyListener() {
        }

        private void notifyKeyTyped(KeyPressed keyPressed) {
            OffScreenRenderWidget.this.browserWidget().dispatch(KeyTyped.newBuilder((KeyCode)keyPressed.keyCode()).keyModifiers(keyPressed.keyModifiers()).keyLocation(keyPressed.keyLocation()).keyChar(keyPressed.keyChar()).build());
        }

        public void keyPressed(KeyEvent e) {
            this.suppressTraversalKey(e);
            KeyCode keyCode = OffScreenRenderWidget.this.nativeKeyCodes.toKeyCode(e.keyCode, e.keyLocation);
            KeyPressed keyPressed = KeyPressed.newBuilder((KeyCode)keyCode).keyModifiers(OffScreenRenderWidget.this.keyModifiers(e)).keyLocation(OffScreenRenderWidget.this.keyLocation(e)).keyChar(e.character).build();
            OffScreenRenderWidget.this.browserWidget().dispatch(keyPressed);
            this.notifyKeyTyped(keyPressed);
        }

        private void suppressTraversalKey(KeyEvent event) {
            if (event.keyCode == 9) {
                event.doit = false;
            }
        }

        public void keyReleased(KeyEvent e) {
            KeyCode keyCode = OffScreenRenderWidget.this.nativeKeyCodes.toKeyCode(e.keyCode, e.keyLocation);
            OffScreenRenderWidget.this.browserWidget().dispatch(KeyReleased.newBuilder((KeyCode)keyCode).keyModifiers(OffScreenRenderWidget.this.keyModifiers(e)).keyLocation(OffScreenRenderWidget.this.keyLocation(e)).build());
        }
    }

    final class MouseWheelListener
    implements org.eclipse.swt.events.MouseWheelListener {
        MouseWheelListener() {
        }

        public void mouseScrolled(MouseEvent event) {
            if (!OffScreenRenderWidget.this.isEnabled()) {
                return;
            }
            ScrollType scrollType = ScrollType.SCROLL_TYPE_UNSPECIFIED;
            if ((event.widget.getStyle() & 1) != 0) {
                scrollType = ScrollType.UNIT_SCROLL;
            } else if ((event.widget.getStyle() & 2) != 0) {
                scrollType = ScrollType.BLOCK_SCROLL;
            }
            float pointsPerUnit = Environment.isMac() ? 10.0f : 33.333332f;
            float delta = (float)event.count * pointsPerUnit;
            float deltaX = OffScreenRenderWidget.this.isShiftDown(event) ? delta : 0.0f;
            float deltaY = !OffScreenRenderWidget.this.isShiftDown(event) ? delta : 0.0f;
            OffScreenRenderWidget.this.browserWidget().dispatch(MouseWheel.newBuilder((Point)OffScreenRenderWidget.this.localPoint(event)).locationOnScreen(OffScreenRenderWidget.this.screenPoint(event)).deltaX(deltaX).deltaY(deltaY).keyModifiers(OffScreenRenderWidget.this.keyModifiers(event)).scrollType(scrollType).build());
        }
    }

    final class MouseMotionListener
    implements MouseMoveListener {
        MouseMotionListener() {
        }

        public void mouseMove(MouseEvent e) {
            if (!OffScreenRenderWidget.this.isEnabled()) {
                return;
            }
            if ((e.stateMask & SWT.BUTTON_MASK) == 0) {
                OffScreenRenderWidget.this.dispatchMouseMoved(e);
            } else {
                OffScreenRenderWidget.this.dispatchMouseDragged(e);
            }
        }
    }

    final class MouseListener
    extends MouseAdapter {
        MouseListener() {
        }

        public void mouseDown(MouseEvent event) {
            if (!OffScreenRenderWidget.this.isEnabled()) {
                return;
            }
            OffScreenRenderWidget.this.requestFocusIfNecessary();
            OffScreenRenderWidget.this.browserWidget().dispatch(MousePressed.newBuilder((Point)OffScreenRenderWidget.this.localPoint(event)).button(OffScreenRenderWidget.mouseButton(event)).locationOnScreen(OffScreenRenderWidget.this.screenPoint(event)).clickCount(event.count).mouseModifiers(OffScreenRenderWidget.mouseModifiers(event)).keyModifiers(OffScreenRenderWidget.this.keyModifiers(event)).build());
        }

        public void mouseUp(MouseEvent event) {
            if (!OffScreenRenderWidget.this.isEnabled()) {
                return;
            }
            OffScreenRenderWidget.this.browserWidget().dispatch(MouseReleased.newBuilder((Point)OffScreenRenderWidget.this.localPoint(event)).button(OffScreenRenderWidget.mouseButton(event)).locationOnScreen(OffScreenRenderWidget.this.screenPoint(event)).mouseModifiers(OffScreenRenderWidget.mouseModifiers(event)).keyModifiers(OffScreenRenderWidget.this.keyModifiers(event)).build());
        }
    }

    final class MouseTrackListener
    extends MouseTrackAdapter {
        MouseTrackListener() {
        }

        public void mouseEnter(MouseEvent event) {
            if (!OffScreenRenderWidget.this.isEnabled()) {
                return;
            }
            OffScreenRenderWidget.this.browserWidget().dispatch(MouseEntered.newBuilder((Point)OffScreenRenderWidget.this.localPoint(event)).button(OffScreenRenderWidget.mouseButton(event)).locationOnScreen(OffScreenRenderWidget.this.screenPoint(event)).mouseModifiers(OffScreenRenderWidget.mouseModifiers(event)).keyModifiers(OffScreenRenderWidget.this.keyModifiers(event)).build());
        }

        public void mouseExit(MouseEvent event) {
            if (!OffScreenRenderWidget.this.isEnabled()) {
                return;
            }
            OffScreenRenderWidget.this.browserWidget().dispatch(MouseExited.newBuilder((Point)OffScreenRenderWidget.this.localPoint(event)).button(OffScreenRenderWidget.mouseButton(event)).locationOnScreen(OffScreenRenderWidget.this.screenPoint(event)).mouseModifiers(OffScreenRenderWidget.mouseModifiers(event)).keyModifiers(OffScreenRenderWidget.this.keyModifiers(event)).build());
        }
    }
}

