/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swt.internal;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.view.swt.internal.SwtAutoScaleProperty;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

final class DpiAwareRectangle {
    private static final double DPI_ZOOM_100 = 96.0;
    private final Rectangle original;
    private final Display display;
    private final double systemScaleFactor;
    private Double scaleFactor;

    DpiAwareRectangle(Rectangle original, Display display, double systemScaleFactor) {
        this.original = (Rectangle)Preconditions.checkNotNull((Object)original);
        this.display = (Display)Preconditions.checkNotNull((Object)display);
        this.systemScaleFactor = systemScaleFactor;
    }

    int x() {
        return this.scale(this.original.x);
    }

    int y() {
        return this.scale(this.original.y);
    }

    int width() {
        return this.scale(this.original.width);
    }

    int height() {
        return this.scale(this.original.height);
    }

    private int scale(int original) {
        return (int)Math.round((double)original * this.scaleFactor());
    }

    private Double scaleFactor() {
        if (this.scaleFactor == null) {
            this.scaleFactor = SwtAutoScaleProperty.doubleValue().map(doubleValue -> doubleValue / this.systemScaleFactor).orElseGet(() -> 96.0 / (double)this.display.getDPI().x);
        }
        return this.scaleFactor;
    }
}

