/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.internal.menu;

import com.teamdev.jxbrowser.browser.callback.ShowContextMenuCallback;
import com.teamdev.jxbrowser.ui.Point;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public abstract class ContextMenu {
    private final JComponent component;
    private final ShowContextMenuCallback.Params params;
    private final ShowContextMenuCallback.Action callback;

    ContextMenu(JComponent component, ShowContextMenuCallback.Params params, ShowContextMenuCallback.Action callback) {
        this.component = component;
        this.params = params;
        this.callback = callback;
    }

    protected ShowContextMenuCallback.Params params() {
        return this.params;
    }

    protected ShowContextMenuCallback.Action callback() {
        return this.callback;
    }

    protected abstract void initialize(JPopupMenu var1);

    public final void show() {
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.setLightWeightPopupEnabled(false);
        popupMenu.addPopupMenuListener(new PopupMenuListenerImpl());
        this.initialize(popupMenu);
        Point location = this.params.location();
        int x = location.x();
        int y = location.y();
        SwingUtilities.invokeLater(() -> {
            this.component.setEnabled(false);
            popupMenu.show(this.component, x, y);
        });
    }

    private void notifyContextMenuClosed() {
        this.component.setEnabled(true);
        if (!this.callback.isClosed()) {
            this.callback.close();
        }
    }

    private class PopupMenuListenerImpl
    implements PopupMenuListener {
        private PopupMenuListenerImpl() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            SwingUtilities.invokeLater(() -> ContextMenu.this.notifyContextMenuClosed());
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }
    }
}

