/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.internal.dnd.parser;

import com.teamdev.jxbrowser.browser.internal.rpc.DropData;
import com.teamdev.jxbrowser.browser.internal.rpc.DropMetadata;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.view.swing.internal.dnd.parser.TransferableParser;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.List;

public final class TextTransferableParser
implements TransferableParser {
    private static final List<DataFlavor> supportedDataFlavors = new ArrayList<DataFlavor>();

    @Override
    public boolean canParse(Transferable transferable) {
        for (DataFlavor dataFlavor : transferable.getTransferDataFlavors()) {
            if (!supportedDataFlavors.contains(dataFlavor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void parse(Transferable transferable, DropData.Builder builder) {
        for (DataFlavor dataFlavor : supportedDataFlavors) {
            try {
                if (!transferable.isDataFlavorSupported(dataFlavor)) continue;
                builder.setText((String)transferable.getTransferData(dataFlavor));
                return;
            }
            catch (Exception e) {
                Logger.debug((String)"Failed to parse transferable.", (Object[])new Object[]{e});
            }
        }
    }

    @Override
    public void parse(Transferable transferable, DropMetadata.Builder builder) {
        builder.setContainsText(this.canParse(transferable));
    }

    static {
        try {
            supportedDataFlavors.add(new DataFlavor("text/plain; class=java.lang.String"));
            supportedDataFlavors.add(DataFlavor.stringFlavor);
        }
        catch (Exception e) {
            Logger.debug((String)"Failed to initialize TextTransferableParser: ", (Object[])new Object[]{e});
        }
    }
}

