/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.internal.dnd;

import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.browser.internal.DragAndDrop;
import com.teamdev.jxbrowser.browser.internal.callback.DragAndDropCallback;
import com.teamdev.jxbrowser.browser.internal.callback.StartDragCallback;
import com.teamdev.jxbrowser.browser.internal.rpc.DragCursorUpdated;
import com.teamdev.jxbrowser.browser.internal.rpc.DragOperation;
import com.teamdev.jxbrowser.browser.internal.rpc.DropData;
import com.teamdev.jxbrowser.browser.internal.rpc.DropMetadata;
import com.teamdev.jxbrowser.browser.internal.rpc.StartDrag;
import com.teamdev.jxbrowser.deps.com.google.protobuf.ByteString;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.internal.Display;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.ui.internal.Geometry;
import com.teamdev.jxbrowser.ui.internal.rpc.Bitmap;
import com.teamdev.jxbrowser.ui.internal.rpc.Size;
import com.teamdev.jxbrowser.view.swing.graphics.BitmapImage;
import com.teamdev.jxbrowser.view.swing.internal.ComponentLocator;
import com.teamdev.jxbrowser.view.swing.internal.Platform;
import com.teamdev.jxbrowser.view.swing.internal.ToolkitConverters;
import com.teamdev.jxbrowser.view.swing.internal.dnd.BrowserTransferable;
import com.teamdev.jxbrowser.view.swing.internal.dnd.DragActionConverter;
import com.teamdev.jxbrowser.view.swing.internal.dnd.DragContext;
import com.teamdev.jxbrowser.view.swing.internal.dnd.parser.FileTransferableParser;
import com.teamdev.jxbrowser.view.swing.internal.dnd.parser.HtmlTransferableParser;
import com.teamdev.jxbrowser.view.swing.internal.dnd.parser.NoFlavorTransferableParser;
import com.teamdev.jxbrowser.view.swing.internal.dnd.parser.TextTransferableParser;
import com.teamdev.jxbrowser.view.swing.internal.dnd.parser.TransferableParser;
import com.teamdev.jxbrowser.view.swing.internal.dnd.parser.UrlTransferableParser;
import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

public final class DragAndDropHelper {
    private static final Image DUMMY_DRAG_IMAGE = BitmapImage.toToolkit((com.teamdev.jxbrowser.ui.Bitmap)Bitmap.newBuilder().setSize(Size.newBuilder().setWidth(1).setHeight(1).build()).setPixels(ByteString.copyFrom((byte[])new byte[]{0, 0, 0, 0})).build());
    private final BrowserWidget widget;
    private final JComponent component;
    private final DragAndDrop dragAndDrop;
    private final DragContext context;
    private final DropTarget dropTarget;
    private final DragGestureRecognizer dragGestureRecognizer;
    private State state;
    private Display display;
    private Subscription dragCursorUpdated;

    public DragAndDropHelper(JComponent component, BrowserWidget widget, Display display) {
        this.widget = widget;
        this.component = component;
        this.display = display;
        this.context = new DragContext();
        this.dragAndDrop = widget.browser().dragAndDrop();
        this.dropTarget = new DropTarget(null, new DropListener());
        DragSource dragSource = new DragSource();
        this.dragGestureRecognizer = dragSource.createDefaultDragGestureRecognizer(null, 0x40000003, new DragListener());
        component.setTransferHandler(new DefaultTransferHandler());
        this.state = State.DETACHED;
    }

    public void attach() {
        if (this.state == State.ATTACHED) {
            return;
        }
        this.dropTarget.setComponent(this.component);
        this.dragGestureRecognizer.setComponent(this.component);
        this.dragAndDrop.set(StartDragCallback.class, (DragAndDropCallback)((StartDragCallback)this::startDrag));
        this.dragCursorUpdated = this.widget.on(DragCursorUpdated.class, this::updateDragCursor);
        this.state = State.ATTACHED;
    }

    public void detach() {
        if (this.state == State.DETACHED) {
            return;
        }
        this.dropTarget.setComponent(null);
        this.dragGestureRecognizer.setComponent(null);
        this.dragAndDrop.remove(StartDragCallback.class);
        this.dragCursorUpdated.unsubscribe();
        this.state = State.DETACHED;
    }

    private StartDrag.Response startDrag(StartDrag.Request params) {
        BrowserTransferable transferable = BrowserTransferable.newInstance();
        transferable.setData(params.getDropData());
        java.awt.Point imageOffset = ToolkitConverters.toPoint((Point)params.getDragImageOffset());
        Bitmap dragImageBitmap = params.getDragImage();
        Bitmap dragImage1xBitmap = params.getDragImage1X();
        if (!dragImageBitmap.size().isEmpty() && !dragImage1xBitmap.size().isEmpty()) {
            BufferedImage image = BitmapImage.toToolkit((com.teamdev.jxbrowser.ui.Bitmap)dragImageBitmap);
            BufferedImage image1x = BitmapImage.toToolkit((com.teamdev.jxbrowser.ui.Bitmap)dragImage1xBitmap);
            Image dragImage = Platform.instance().createMultiResolutionImage(image1x, image);
            if (Environment.isMac()) {
                imageOffset.x = -imageOffset.x;
                imageOffset.y = -imageOffset.y;
            }
            this.context.startDragging(transferable, dragImage, imageOffset);
        } else {
            this.context.startDragging(transferable, DUMMY_DRAG_IMAGE, imageOffset);
        }
        return StartDrag.Response.newBuilder().build();
    }

    private void updateDragCursor(DragCursorUpdated event) {
        this.context.operation(event.getDragOperation());
    }

    public boolean isDragging() {
        return this.context.isDragging();
    }

    public void onDisplayChanged(Display display) {
        this.display = display;
    }

    private class DragListener
    extends DragSourceAdapter
    implements DragGestureListener {
        private DragListener() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            if (!DragAndDropHelper.this.context.isDragging()) {
                return;
            }
            DragSource dragSource = dge.getDragSource();
            BrowserTransferable transferable = (BrowserTransferable)DragAndDropHelper.this.context.transferable();
            Image dragImage = DragAndDropHelper.this.context.dragImage();
            java.awt.Point imageOffset = DragAndDropHelper.this.context.imageOffset();
            DragAndDropHelper.this.component.getTransferHandler().setDragImage(dragImage);
            DragAndDropHelper.this.component.getTransferHandler().setDragImageOffset(imageOffset);
            dragSource.startDrag(dge, null, dragImage, imageOffset, transferable, this);
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
            Point location = ToolkitConverters.toProtoPoint(dsde.getLocation());
            DragOperation operation = (DragOperation)new DragActionConverter().convert(dsde.getDropAction());
            if (!Platform.instance().isDpiAware()) {
                location = Geometry.scaleDown((Point)location, (double)DragAndDropHelper.this.display.scaleFactor());
            }
            DragAndDropHelper.this.widget.dragEnd(Point.empty(), location, operation);
            DragAndDropHelper.this.context.endDragging();
        }
    }

    private class DropListener
    extends DropTargetAdapter {
        private final List<TransferableParser> parsers = new ArrayList<TransferableParser>();

        DropListener() {
            this.parsers.add(new TextTransferableParser());
            this.parsers.add(new UrlTransferableParser());
            this.parsers.add(new HtmlTransferableParser());
            this.parsers.add(new FileTransferableParser());
            this.parsers.add(new NoFlavorTransferableParser());
        }

        private void postProcessParsedData(DropData.Builder builder) {
            if (builder.getUrl().isEmpty() && UrlTransferableParser.isDataFormat(builder.getText())) {
                builder.setUrl(builder.getText());
            }
            if (builder.getText().isEmpty()) {
                builder.setText(builder.getUrl());
            }
        }

        private boolean canParse(Transferable transferable) {
            for (TransferableParser parser : this.parsers) {
                if (!parser.canParse(transferable)) continue;
                return true;
            }
            return false;
        }

        private DropData parse(Transferable transferable) {
            DropData.Builder builder = DropData.newBuilder();
            for (TransferableParser parser : this.parsers) {
                parser.parse(transferable, builder);
            }
            this.postProcessParsedData(builder);
            return builder.build();
        }

        private DropMetadata parseMetadata(Transferable transferable) {
            DropMetadata.Builder builder = DropMetadata.newBuilder();
            for (TransferableParser parser : this.parsers) {
                parser.parse(transferable, builder);
            }
            return builder.build();
        }

        private void acceptOrReject(DropTargetDragEvent event) {
            if (DragAndDropHelper.this.context.isDragging()) {
                DragOperation operation = DragAndDropHelper.this.context.operation();
                if (operation == DragOperation.OPERATION_NONE) {
                    event.rejectDrag();
                } else {
                    event.acceptDrag(this.toAwtOperation(operation));
                }
            } else {
                event.acceptDrag(1);
            }
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            if (!this.canParse(dtde.getTransferable())) {
                dtde.rejectDrag();
                return;
            }
            Point location = ToolkitConverters.toProtoPoint(dtde.getLocation());
            Point locationOnScreen = ToolkitConverters.toProtoPoint(ComponentLocator.locationOnScreen(DragAndDropHelper.this.component));
            Point screenLocation = Geometry.newPoint((double)(locationOnScreen.x() + location.x()), (double)(locationOnScreen.y() + location.y()));
            DropMetadata dropMetadata = this.parseMetadata(dtde.getTransferable());
            int operationsAllowed = DragActionConverter.toDragOperationMask(dtde.getSourceActions());
            if (!Platform.instance().isDpiAware()) {
                location = Geometry.scaleDown((Point)location, (double)DragAndDropHelper.this.display.scaleFactor());
                screenLocation = Geometry.scaleDown((Point)screenLocation, (double)DragAndDropHelper.this.display.scaleFactor());
            }
            DragAndDropHelper.this.widget.dragEnter(dropMetadata, location, screenLocation, operationsAllowed);
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            if (!this.canParse(dtde.getTransferable())) {
                dtde.rejectDrag();
                return;
            }
            this.acceptOrReject(dtde);
            Point location = ToolkitConverters.toProtoPoint(dtde.getLocation());
            Point locationOnScreen = ToolkitConverters.toProtoPoint(ComponentLocator.locationOnScreen(DragAndDropHelper.this.component));
            Point screenLocation = Geometry.newPoint((double)(locationOnScreen.x() + location.x()), (double)(locationOnScreen.y() + location.y()));
            int operationsAllowed = DragActionConverter.toDragOperationMask(dtde.getSourceActions());
            if (!Platform.instance().isDpiAware()) {
                location = Geometry.scaleDown((Point)location, (double)DragAndDropHelper.this.display.scaleFactor());
                screenLocation = Geometry.scaleDown((Point)screenLocation, (double)DragAndDropHelper.this.display.scaleFactor());
            }
            DragAndDropHelper.this.widget.dragOver(location, screenLocation, operationsAllowed);
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
            DragAndDropHelper.this.widget.dragLeave();
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            Point location = ToolkitConverters.toProtoPoint(dtde.getLocation());
            Point locationOnScreen = ToolkitConverters.toProtoPoint(ComponentLocator.locationOnScreen(DragAndDropHelper.this.component));
            Point screenLocation = Geometry.newPoint((double)(locationOnScreen.x() + location.x()), (double)(locationOnScreen.y() + location.y()));
            dtde.acceptDrop(dtde.getDropAction());
            DropData dropData = this.parse(dtde.getTransferable());
            if (!Platform.instance().isDpiAware()) {
                location = Geometry.scaleDown((Point)location, (double)DragAndDropHelper.this.display.scaleFactor());
                screenLocation = Geometry.scaleDown((Point)screenLocation, (double)DragAndDropHelper.this.display.scaleFactor());
            }
            DragAndDropHelper.this.widget.drop(dropData, location, screenLocation);
        }

        private Integer toAwtOperation(DragOperation operation) {
            return (Integer)new DragActionConverter().reverse().convert((Object)operation);
        }
    }

    private static final class DefaultTransferHandler
    extends TransferHandler {
        private DefaultTransferHandler() {
        }
    }

    private static enum State {
        ATTACHED,
        DETACHED;

    }
}

