/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.internal.dnd;

import com.teamdev.jxbrowser.browser.internal.rpc.DropData;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.view.swing.internal.dnd.BrowserTransferableMac;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class BrowserTransferable
implements Transferable {
    private static final DataFlavor STRING_FLAVOR = DataFlavor.stringFlavor;
    private static final DataFlavor HTML_FLAVOR = DataFlavor.fragmentHtmlFlavor;
    private static final DataFlavor URL_FLAVOR = BrowserTransferable.createStringFlavor("application/x-java-url", "URL");
    private static final DataFlavor URI_FLAVOR = BrowserTransferable.createStringFlavor("text/uri-list", "URI list");
    private static final DataFlavor TEXT_FLAVOR = BrowserTransferable.createStringFlavor("text/plain", "Plain text");
    private final Map<DataFlavor, Object> data = new HashMap<DataFlavor, Object>();

    BrowserTransferable() {
    }

    private static DataFlavor createStringFlavor(String mimeType, String name) {
        try {
            return new DataFlavor(mimeType + "; class=java.lang.String; charset=Unicode", name);
        }
        catch (Exception e) {
            Logger.warn((String)"Failed to create a data flavor for the type: {0}", (Object[])new Object[]{e, mimeType});
            return null;
        }
    }

    static BrowserTransferable newInstance() {
        if (Environment.isMac()) {
            return new BrowserTransferableMac();
        }
        return new BrowserTransferable();
    }

    final void setData(DropData dropData) {
        String url = dropData.getUrl();
        String text = dropData.getText();
        String html = dropData.getHtml();
        String htmlBaseUrl = dropData.getHtmlBaseUrl();
        if (!url.isEmpty()) {
            this.addData(URL_FLAVOR, url);
            this.addData(TEXT_FLAVOR, url);
            this.addData(STRING_FLAVOR, url);
            this.setUrl(url);
        }
        if (!htmlBaseUrl.isEmpty() || !html.isEmpty()) {
            this.addData(HTML_FLAVOR, html);
        }
        if (!text.isEmpty()) {
            this.addData(TEXT_FLAVOR, text);
            this.addData(STRING_FLAVOR, text);
        }
    }

    protected void setUrl(String url) {
        this.addData(URI_FLAVOR, url);
    }

    final void addData(DataFlavor flavor, Object transferData) {
        if (flavor == null) {
            return;
        }
        this.data.put(flavor, transferData);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        Set<DataFlavor> dataFlavors = this.data.keySet();
        return dataFlavors.toArray(new DataFlavor[0]);
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return this.data.containsKey(flavor);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (!this.data.containsKey(flavor)) {
            throw new UnsupportedFlavorException(flavor);
        }
        return this.data.get(flavor);
    }
}

