/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.internal;

import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.browser.internal.WebDialog;
import com.teamdev.jxbrowser.browser.internal.callback.BrowserWidgetCallback;
import com.teamdev.jxbrowser.browser.internal.callback.UpdateSurfaceCallback;
import com.teamdev.jxbrowser.browser.internal.rpc.UpdateSurface;
import com.teamdev.jxbrowser.browser.internal.rpc.WebDialogCreated;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.internal.AwtHelperLibrary;
import com.teamdev.jxbrowser.ui.Rect;
import com.teamdev.jxbrowser.view.internal.mac.NsView;
import com.teamdev.jxbrowser.view.swing.internal.ComponentLocator;
import com.teamdev.jxbrowser.view.swing.internal.IoSurfaceWebDialogView;
import com.teamdev.jxbrowser.view.swing.internal.OffScreenRenderWidget;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.SwingUtilities;

public final class IoSurfaceRenderWidget
extends OffScreenRenderWidget {
    private final NsView nsView = new NsView();
    private final ResizeListener resizeListener = new ResizeListener();
    private final Subscription webDialogCreated;
    private final AwtHelperLibrary awtHelperLibrary = AwtHelperLibrary.instance();

    public IoSurfaceRenderWidget(BrowserWidget widget) {
        super(widget);
        this.webDialogCreated = widget.on(WebDialogCreated.class, event -> {
            long nsViewId;
            WebDialog webDialog = new WebDialog(widget.browser(), event.getWebDialogId());
            IoSurfaceWebDialogView webDialogView = new IoSurfaceWebDialogView(this, webDialog);
            Window window = SwingUtilities.getWindowAncestor(this);
            if (window != null && (nsViewId = this.awtHelperLibrary.getWindowHandle(window)) != 0L) {
                webDialogView.show(nsViewId, (Rect)event.getInitialBounds());
            }
        });
        this.widget().set(UpdateSurfaceCallback.class, (BrowserWidgetCallback)((UpdateSurfaceCallback)params -> {
            this.nsView.updateSurface(params.getSurfaceId(), params.getScaleFactor());
            return UpdateSurface.Response.newBuilder().build();
        }));
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        Rectangle bounds = this.getComponentBounds();
        if (bounds.width > 0 && bounds.height >= 0) {
            this.nsView.updateBounds(Rect.of((int)bounds.x, (int)bounds.y, (int)bounds.width, (int)bounds.height));
        }
    }

    @Override
    public void close() {
        this.webDialogCreated.unsubscribe();
        this.nsView.close();
        super.close();
    }

    @Override
    protected void showRenderWidget() {
        long parentViewId;
        if (!this.isShowing()) {
            return;
        }
        if (this.isShown()) {
            return;
        }
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window != null && (parentViewId = this.awtHelperLibrary.getWindowHandle(window)) != 0L) {
            Rectangle bounds = this.getComponentBounds();
            this.nsView.show(parentViewId, Rect.of((int)bounds.x, (int)bounds.y, (int)bounds.width, (int)bounds.height));
        }
        this.addComponentListener(this.resizeListener);
        this.widget().attach(0L);
        super.showRenderWidget();
    }

    @Override
    protected void hideRenderWidget() {
        if (!this.isShown()) {
            return;
        }
        super.hideRenderWidget();
        this.removeComponentListener(this.resizeListener);
        this.nsView.hide();
    }

    private Rectangle getComponentBounds() {
        Rectangle bounds = this.getBounds();
        bounds.setLocation(ComponentLocator.locationInWindow(this));
        return bounds;
    }

    private class ResizeListener
    extends ComponentAdapter {
        private ResizeListener() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            Rectangle bounds = IoSurfaceRenderWidget.this.getComponentBounds();
            if (bounds.width >= 0 && bounds.height >= 0) {
                IoSurfaceRenderWidget.this.nsView.updateBounds(Rect.of((int)bounds.x, (int)bounds.y, (int)bounds.width, (int)bounds.height));
            }
        }
    }
}

