/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.callback;

import com.teamdev.jxbrowser.browser.callback.OpenFilesCallback;
import com.teamdev.jxbrowser.view.swing.callback.DefaultCallback;
import com.teamdev.jxbrowser.view.swing.internal.FileChooser;
import java.awt.Component;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public final class DefaultOpenFilesCallback
extends DefaultCallback
implements OpenFilesCallback {
    public DefaultOpenFilesCallback(JComponent parent) {
        super(parent);
    }

    public void on(OpenFilesCallback.Params params, OpenFilesCallback.Action tell) {
        SwingUtilities.invokeLater(() -> {
            FileChooser fileChooser = new FileChooser(params.filterDescription(), params.acceptableExtensions());
            fileChooser.setMultiSelectionEnabled(true);
            if (fileChooser.showOpenDialog((Component)this.widget()) == 0) {
                Stream<Path> paths = Arrays.stream(fileChooser.selectedFiles()).map(File::toPath);
                tell.open((Path[])paths.toArray(Path[]::new));
            } else {
                tell.cancel();
            }
        });
    }
}

