/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing;

import com.teamdev.jxbrowser.browser.Browser;
import com.teamdev.jxbrowser.browser.callback.BrowserCallback;
import com.teamdev.jxbrowser.browser.callback.CreatePopupCallback;
import com.teamdev.jxbrowser.browser.event.BrowserClosed;
import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.callback.Advisable;
import com.teamdev.jxbrowser.callback.Callback;
import com.teamdev.jxbrowser.callback.internal.DefaultCallbacks;
import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.engine.RenderingMode;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.view.swing.DragAndDrop;
import com.teamdev.jxbrowser.view.swing.callback.DefaultAlertCallback;
import com.teamdev.jxbrowser.view.swing.callback.DefaultBeforeFormRepostCallback;
import com.teamdev.jxbrowser.view.swing.callback.DefaultBeforeUnloadCallback;
import com.teamdev.jxbrowser.view.swing.callback.DefaultConfirmCallback;
import com.teamdev.jxbrowser.view.swing.callback.DefaultOpenFileCallback;
import com.teamdev.jxbrowser.view.swing.callback.DefaultOpenFilesCallback;
import com.teamdev.jxbrowser.view.swing.callback.DefaultOpenFolderCallback;
import com.teamdev.jxbrowser.view.swing.callback.DefaultOpenPopupCallback;
import com.teamdev.jxbrowser.view.swing.callback.DefaultPrintCallback;
import com.teamdev.jxbrowser.view.swing.callback.DefaultPromptCallback;
import com.teamdev.jxbrowser.view.swing.callback.DefaultSaveAsPdfCallback;
import com.teamdev.jxbrowser.view.swing.callback.DefaultSelectClientCertificateCallback;
import com.teamdev.jxbrowser.view.swing.callback.DefaultSelectColorCallback;
import com.teamdev.jxbrowser.view.swing.callback.DefaultShowContextMenuCallback;
import com.teamdev.jxbrowser.view.swing.callback.DefaultStartDownloadCallback;
import com.teamdev.jxbrowser.view.swing.internal.Graphics2dRenderWidget;
import com.teamdev.jxbrowser.view.swing.internal.IoSurfaceRenderWidget;
import com.teamdev.jxbrowser.view.swing.internal.Widget;
import com.teamdev.jxbrowser.view.swing.internal.WindowedWidget;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public final class BrowserView
extends JComponent {
    private final Browser browser;
    private final DragAndDrop dragAndDrop;
    private final DefaultCallbacks<BrowserCallback> defaultCallbacks;
    private Subscription onBrowserClosed;
    private Widget widget;

    public static BrowserView newInstance(Browser browser) {
        return new BrowserView(browser);
    }

    private BrowserView(Browser browser) {
        Preconditions.checkNotNull((Object)browser);
        Logger.debug((String)"UI Toolkit: Swing");
        this.browser = browser;
        this.setOpaque(false);
        this.setBackground(Color.WHITE);
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(800, 600));
        this.defaultCallbacks = this.defaultCallbacks();
        if (browser instanceof BrowserImpl) {
            this.widget = this.createBrowserWidget((BrowserImpl)browser);
            this.addWidget(this.widget.asComponent());
            this.onBrowserClosed = browser.on(BrowserClosed.class, event -> {
                this.removeWidget(this.widget.asComponent());
                this.defaultCallbacks.unregister();
                this.onBrowserClosed.unsubscribe();
            });
        }
        this.dragAndDrop = new DragAndDropSupport();
        this.defaultCallbacks.register();
    }

    private void removeWidget(JComponent widget) {
        SwingUtilities.invokeLater(() -> {
            this.remove(widget);
            this.validate();
            this.repaint();
        });
    }

    private void addWidget(JComponent widget) {
        SwingUtilities.invokeLater(() -> {
            this.add((Component)widget, "Center");
            this.validate();
            this.repaint();
        });
    }

    private DefaultCallbacks<BrowserCallback> defaultCallbacks() {
        return DefaultCallbacks.of((Advisable)this.browser).add((Callback)((CreatePopupCallback)params -> CreatePopupCallback.Response.create())).add((Callback)new DefaultOpenPopupCallback()).add((Callback)new DefaultAlertCallback(this)).add((Callback)new DefaultConfirmCallback(this)).add((Callback)new DefaultPromptCallback(this)).add((Callback)new DefaultOpenFileCallback(this)).add((Callback)new DefaultOpenFilesCallback(this)).add((Callback)new DefaultOpenFolderCallback(this)).add((Callback)new DefaultSaveAsPdfCallback(this)).add((Callback)new DefaultSelectColorCallback(this)).add((Callback)new DefaultBeforeUnloadCallback(this)).add((Callback)new DefaultSelectClientCertificateCallback(this)).add((Callback)new DefaultBeforeFormRepostCallback(this)).add((Callback)new DefaultPrintCallback()).add((Callback)new DefaultShowContextMenuCallback(this)).add((Callback)new DefaultStartDownloadCallback(this)).build();
    }

    private Widget createBrowserWidget(BrowserImpl browser) {
        RenderingMode renderingMode = browser.engine().options().renderingMode();
        if (renderingMode == RenderingMode.OFF_SCREEN) {
            return new Graphics2dRenderWidget(browser.widget());
        }
        if (renderingMode == RenderingMode.HARDWARE_ACCELERATED) {
            if (Environment.isMac()) {
                return new IoSurfaceRenderWidget(browser.widget());
            }
            if (Environment.isWindows() || Environment.isLinux()) {
                return new WindowedWidget(browser.widget());
            }
        }
        throw new IllegalStateException("Unsupported operating system");
    }

    public Browser getBrowser() {
        return this.browser;
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
        if (this.widget != null) {
            this.widget.asComponent().requestFocus();
        }
    }

    @Override
    public boolean requestFocus(boolean temporary) {
        if (this.widget != null) {
            return this.widget.asComponent().requestFocus(temporary);
        }
        return super.requestFocus(temporary);
    }

    @Override
    public boolean requestFocusInWindow() {
        if (this.widget != null) {
            return this.widget.asComponent().requestFocusInWindow();
        }
        return super.requestFocusInWindow();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.widget != null) {
            this.widget.asComponent().setVisible(visible);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.widget != null) {
            this.widget.asComponent().setEnabled(enabled);
        }
    }

    public DragAndDrop dragAndDrop() {
        return this.dragAndDrop;
    }

    private class DragAndDropSupport
    implements DragAndDrop {
        private DragAndDropSupport() {
        }

        @Override
        public void enable() {
            if (GraphicsEnvironment.isHeadless()) {
                return;
            }
            if (BrowserView.this.browser instanceof BrowserImpl) {
                ((BrowserImpl)BrowserView.this.browser).dragAndDrop().enable();
            }
            if (BrowserView.this.widget != null) {
                BrowserView.this.widget.enableDragAndDrop();
            }
        }

        @Override
        public void disable() {
            if (GraphicsEnvironment.isHeadless()) {
                return;
            }
            if (BrowserView.this.widget != null) {
                BrowserView.this.widget.disableDragAndDrop();
            }
            if (BrowserView.this.browser instanceof BrowserImpl) {
                ((BrowserImpl)BrowserView.this.browser).dragAndDrop().disable();
            }
        }

        @Override
        public boolean isEnabled() {
            if (GraphicsEnvironment.isHeadless()) {
                return false;
            }
            if (BrowserView.this.browser instanceof BrowserImpl) {
                return ((BrowserImpl)BrowserView.this.browser).dragAndDrop().isEnabled();
            }
            return false;
        }
    }
}

