/*
 * Decompiled with CFR 0.152.
 */
package com.tdunning.math.stats;

import com.tdunning.math.stats.ArrayDigest;
import com.tdunning.math.stats.Centroid;
import com.tdunning.math.stats.GroupTree;
import com.tdunning.math.stats.TreeDigest;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;

public abstract class TDigest {
    protected Random gen = new Random();
    protected boolean recordAllData = false;

    public static TDigest createArrayDigest(double compression) {
        return new ArrayDigest(32, compression);
    }

    public static TDigest createTreeDigest(double compression) {
        return new TreeDigest(compression);
    }

    public static double interpolate(double x, double x0, double x1) {
        return (x - x0) / (x1 - x0);
    }

    public static void encode(ByteBuffer buf, int n) {
        int k = 0;
        while (n < 0 || n > 127) {
            byte b = (byte)(0x80 | 0x7F & n);
            buf.put(b);
            n >>>= 7;
            if (++k < 6) continue;
            throw new IllegalStateException("Size is implausibly large");
        }
        buf.put((byte)n);
    }

    public static int decode(ByteBuffer buf) {
        byte v = buf.get();
        int z = 0x7F & v;
        int shift = 7;
        while ((v & 0x80) != 0) {
            if (shift > 28) {
                throw new IllegalStateException("Shift too large in decode");
            }
            v = buf.get();
            z += (v & 0x7F) << shift;
            shift += 7;
        }
        return z;
    }

    public abstract void add(double var1, int var3);

    abstract void add(double var1, int var3, Centroid var4);

    protected static TDigest merge(Iterable<TDigest> subData, Random gen, TDigest r) {
        ArrayList<Centroid> centroids = new ArrayList<Centroid>();
        boolean recordAll = false;
        for (TDigest digest : subData) {
            for (Centroid centroid : digest.centroids()) {
                centroids.add(centroid);
            }
            recordAll |= digest.isRecording();
        }
        Collections.shuffle(centroids, gen);
        if (recordAll) {
            r.recordAllData();
        }
        for (Centroid c : centroids) {
            if (r.recordAllData) {
                // empty if block
            }
            r.add(c.mean(), c.count(), c);
        }
        return r;
    }

    abstract void compress();

    abstract void compress(GroupTree var1);

    abstract int size();

    abstract double cdf(double var1);

    abstract double quantile(double var1);

    public static double quantile(double previousIndex, double index, double nextIndex, double previousMean, double nextMean) {
        double delta = nextIndex - previousIndex;
        double previousWeight = (nextIndex - index) / delta;
        double nextWeight = (index - previousIndex) / delta;
        return previousMean * previousWeight + nextMean * nextWeight;
    }

    abstract int centroidCount();

    abstract Iterable<? extends Centroid> centroids();

    abstract double compression();

    abstract int byteSize();

    abstract int smallByteSize();

    abstract void asBytes(ByteBuffer var1);

    abstract void asSmallBytes(ByteBuffer var1);

    public TDigest recordAllData() {
        this.recordAllData = true;
        return this;
    }

    public boolean isRecording() {
        return this.recordAllData;
    }

    public void add(double x) {
        this.add(x, 1);
    }

    public void add(TDigest other) {
        ArrayList<Centroid> tmp = new ArrayList<Centroid>();
        for (Centroid centroid : other.centroids()) {
            tmp.add(centroid);
        }
        Collections.shuffle(tmp, this.gen);
        for (Centroid centroid : tmp) {
            this.add(centroid.mean(), centroid.count(), centroid);
        }
    }

    protected Centroid createCentroid(double mean, int id) {
        return new Centroid(mean, id, this.recordAllData);
    }
}

