/*
 * Decompiled with CFR 0.152.
 */
package com.taxonic.carml.model.impl;

import com.taxonic.carml.model.LogicalSource;
import com.taxonic.carml.model.impl.CarmlResource;
import com.taxonic.carml.model.impl.LogicalSourceSourcePropertyHandler;
import com.taxonic.carml.rdf_mapper.annotations.RdfProperty;
import java.util.Objects;
import org.apache.commons.lang3.builder.MultilineRecursiveToStringStyle;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.eclipse.rdf4j.model.IRI;

public class CarmlLogicalSource
extends CarmlResource
implements LogicalSource {
    private Object source;
    private String iterator;
    private IRI referenceFormulation;

    public CarmlLogicalSource() {
    }

    public CarmlLogicalSource(Object source, String iterator, IRI referenceFormulation) {
        this.source = source;
        this.iterator = iterator;
        this.referenceFormulation = referenceFormulation;
    }

    @Override
    @RdfProperty(value="http://semweb.mmlab.be/ns/rml#source", handler=LogicalSourceSourcePropertyHandler.class)
    public Object getSource() {
        return this.source;
    }

    @Override
    @RdfProperty(value="http://semweb.mmlab.be/ns/rml#iterator")
    public String getIterator() {
        return this.iterator;
    }

    @Override
    @RdfProperty(value="http://semweb.mmlab.be/ns/rml#referenceFormulation")
    public IRI getReferenceFormulation() {
        return this.referenceFormulation;
    }

    public void setSource(Object source) {
        this.source = source;
    }

    public void setIterator(String iterator) {
        this.iterator = iterator;
    }

    public void setReferenceFormulation(IRI referenceFormulation) {
        this.referenceFormulation = referenceFormulation;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, (ToStringStyle)new MultilineRecursiveToStringStyle()).toString();
    }

    public int hashCode() {
        return Objects.hash(this.source, this.iterator, this.referenceFormulation);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CarmlLogicalSource other = (CarmlLogicalSource)obj;
        return Objects.equals(this.source, other.source) && Objects.equals(this.iterator, other.iterator) && Objects.equals(this.referenceFormulation, other.referenceFormulation);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Object source;
        private String iterator;
        private IRI referenceFormulation;

        public Builder source(Object source) {
            this.source = source;
            return this;
        }

        public Builder iterator(String iterator) {
            this.iterator = iterator;
            return this;
        }

        public Builder referenceFormulation(IRI referenceFormulation) {
            this.referenceFormulation = referenceFormulation;
            return this;
        }

        public CarmlLogicalSource build() {
            return new CarmlLogicalSource(this.source, this.iterator, this.referenceFormulation);
        }
    }
}

