/*
 * Decompiled with CFR 0.152.
 */
package com.taxonic.carml.model.impl;

import com.taxonic.carml.model.GraphMap;
import com.taxonic.carml.model.SubjectMap;
import com.taxonic.carml.model.TermType;
import com.taxonic.carml.model.TriplesMap;
import com.taxonic.carml.model.impl.GraphMapImpl;
import com.taxonic.carml.model.impl.TermMapImpl;
import com.taxonic.carml.rdf_mapper.annotations.RdfProperty;
import com.taxonic.carml.rdf_mapper.annotations.RdfType;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;

public class SubjectMapImpl
extends TermMapImpl
implements SubjectMap {
    private Set<IRI> classes;
    private Set<GraphMap> graphMaps;

    public SubjectMapImpl() {
    }

    public SubjectMapImpl(String reference, String inverseExpression, String template, TermType termType, Value constant, TriplesMap functionValue, Set<IRI> classes, Set<GraphMap> graphMaps) {
        super(reference, inverseExpression, template, termType, constant, functionValue);
        this.classes = classes;
        this.graphMaps = graphMaps;
    }

    @Override
    @RdfProperty(value="http://www.w3.org/ns/r2rml#graphMap")
    @RdfType(value=GraphMapImpl.class)
    public Set<GraphMap> getGraphMaps() {
        return this.graphMaps;
    }

    public void setGraphMaps(Set<GraphMap> graphMaps) {
        this.graphMaps = graphMaps;
    }

    @Override
    @RdfProperty(value="http://www.w3.org/ns/r2rml#class")
    public Set<IRI> getClasses() {
        return this.classes;
    }

    public void setClasses(Set<IRI> classes) {
        this.classes = classes;
    }

    public String toString() {
        return "SubjectMapImpl [getGraphMaps()=" + this.getGraphMaps() + ", getClasses()=" + this.getClasses() + ", getReference()=" + this.getReference() + ", getInverseExpression()=" + this.getInverseExpression() + ", getTemplate()=" + this.getTemplate() + ", getTermType()=" + (Object)((Object)this.getTermType()) + ", getConstant()=" + this.getConstant() + ", getFunctionValue()=" + this.getFunctionValue() + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.classes == null ? 0 : this.classes.hashCode());
        result = 31 * result + (this.graphMaps == null ? 0 : this.graphMaps.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubjectMapImpl other = (SubjectMapImpl)obj;
        if (this.classes == null ? other.classes != null : !this.classes.equals(other.classes)) {
            return false;
        }
        return !(this.graphMaps == null ? other.graphMaps != null : !this.graphMaps.equals(other.graphMaps));
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    extends TermMapImpl.Builder {
        private Set<IRI> classes = new LinkedHashSet<IRI>();
        private Set<GraphMap> graphMaps = new LinkedHashSet<GraphMap>();

        @Override
        public Builder reference(String reference) {
            super.reference(reference);
            return this;
        }

        @Override
        public Builder inverseExpression(String inverseExpression) {
            super.inverseExpression(inverseExpression);
            return this;
        }

        @Override
        public Builder template(String template) {
            super.template(template);
            return this;
        }

        @Override
        public Builder termType(TermType termType) {
            super.termType(termType);
            return this;
        }

        @Override
        public Builder constant(Value constant) {
            super.constant(constant);
            return this;
        }

        @Override
        public Builder functionValue(TriplesMap functionValue) {
            super.functionValue(functionValue);
            return this;
        }

        public Builder clazz(IRI clazz) {
            this.classes.add(clazz);
            return this;
        }

        public Builder classes(Set<IRI> classes) {
            this.classes = classes;
            return this;
        }

        public Builder graphMap(GraphMapImpl graphMapImpl) {
            this.graphMaps.add(graphMapImpl);
            return this;
        }

        public Builder graphMaps(Set<GraphMap> graphMaps) {
            this.graphMaps = graphMaps;
            return this;
        }

        public SubjectMapImpl build() {
            return new SubjectMapImpl(this.getReference(), this.getInverseExpression(), this.getTemplate(), this.getTermType(), this.getConstant(), this.getFunctionValue(), this.classes, this.graphMaps);
        }
    }
}

